/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.model;

import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Resource;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Section;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.SectionType;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.common.util.Requires;
import io.rxmicro.documentation.ResourceGroupDefinition;
import io.rxmicro.rest.server.feature.EnableCrossOriginResourceSharing;
import java.util.ArrayList;
import java.util.List;

public final class ResourceGroup {
    private final ResourceGroupDefinition resourceGroupDefinition;
    private final String name;
    private final String description;
    private final RestControllerClassStructure restControllerClassStructure;
    private final List<Resource> resources;
    private final List<String> customSections;

    public ResourceGroup(ResourceGroupDefinition resourceGroupDefinition, String name, String description, RestControllerClassStructure restControllerClassStructure, List<Resource> resources, List<String> customSections) {
        this.resourceGroupDefinition = (ResourceGroupDefinition)Requires.require((Object)resourceGroupDefinition);
        this.name = (String)Requires.require((Object)name);
        this.description = description;
        this.restControllerClassStructure = (RestControllerClassStructure)Requires.require((Object)restControllerClassStructure);
        this.resources = (List)Requires.require(resources);
        this.customSections = (List)Requires.require(customSections);
    }

    public String getRestControllerClass() {
        return this.restControllerClassStructure.getOwnerClass().getSimpleName().toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isDescriptionPresent() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        int index = 0;
        for (ResourceGroupDefinition.Section section : this.resourceGroupDefinition.sectionOrder()) {
            if (section == ResourceGroupDefinition.Section.VERSIONING) {
                if (!this.restControllerClassStructure.getParentUrl().isVersionPresent()) continue;
                sections.add(new Section(SectionType.INVOKE_MACROS, "versioning"));
                continue;
            }
            if (section == ResourceGroupDefinition.Section.CORS) {
                if (this.restControllerClassStructure.getOwnerClass().getAnnotation(EnableCrossOriginResourceSharing.class) == null) continue;
                sections.add(new Section(SectionType.INVOKE_MACROS, "cors"));
                continue;
            }
            sections.add(new Section(SectionType.CUSTOM_TEXT, this.customSections.get(index++)));
        }
        return sections;
    }

    public String getVersionStrategyType() {
        return this.restControllerClassStructure.getParentUrl().isUrlPathVersionStrategy() ? "URL" : "Header";
    }

    public String getApiVersionHeader() {
        return this.restControllerClassStructure.getParentUrl().getVersionHeaderName();
    }

    public String getCurrentApiVersion() {
        return this.restControllerClassStructure.getParentUrl().getVersionValue();
    }

    public List<Resource> getResources() {
        return this.resources;
    }
}

