/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.model;

import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Request;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Response;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethod;
import io.rxmicro.common.util.Requires;
import java.util.Set;
import java.util.TreeSet;

public final class Resource {
    private final HttpMethodMapping httpMethodMapping;
    private final RestControllerMethod restControllerMethod;
    private final String name;
    private final String description;
    private final Request request;
    private final Set<Response> responses;

    private Resource(HttpMethodMapping httpMethodMapping, RestControllerMethod restControllerMethod, String name, String description, Request request, Set<Response> responses) {
        this.httpMethodMapping = (HttpMethodMapping)Requires.require((Object)httpMethodMapping);
        this.restControllerMethod = (RestControllerMethod)Requires.require((Object)restControllerMethod);
        this.name = (String)Requires.require((Object)name);
        this.description = description;
        this.request = request;
        this.responses = responses;
    }

    public RestControllerMethod getRestControllerMethod() {
        return this.restControllerMethod;
    }

    public HttpMethodMapping getHttpMethodMapping() {
        return this.httpMethodMapping;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDescriptionPresent() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public Request getRequest() {
        return this.request;
    }

    public Set<Response> getResponses() {
        return this.responses;
    }

    public static final class Builder {
        private final Set<Response> responses = new TreeSet<Response>();
        private RestControllerMethod restControllerMethod;
        private HttpMethodMapping httpMethodMapping;
        private String name;
        private String description;
        private Request request;

        public Builder setRestControllerMethod(RestControllerMethod restControllerMethod) {
            this.restControllerMethod = restControllerMethod;
            return this;
        }

        public Builder setHttpMethodMapping(HttpMethodMapping httpMethodMapping) {
            this.httpMethodMapping = (HttpMethodMapping)Requires.require((Object)httpMethodMapping);
            return this;
        }

        public Builder setName(String name) {
            this.name = (String)Requires.require((Object)name);
            return this;
        }

        public Builder setDescription(String description) {
            this.description = (String)Requires.require((Object)description);
            return this;
        }

        public Builder setRequest(Request request) {
            this.request = request;
            return this;
        }

        public Builder addResponse(Response response) {
            this.responses.add(response);
            return this;
        }

        public Resource build() {
            return new Resource(this.httpMethodMapping, this.restControllerMethod, this.name, this.description, this.request, this.responses);
        }
    }
}

