/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.model;

import io.rxmicro.annotation.processor.documentation.asciidoctor.model.DocumentedModelField;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Map;

public final class Request {
    private final String example;
    private final List<DocumentedModelField> pathVariables;
    private final List<DocumentedModelField> headers;
    private final List<DocumentedModelField> queryParameters;
    private final List<Map.Entry<String, List<DocumentedModelField>>> bodyParameters;
    private final String schema;

    private Request(String example, List<DocumentedModelField> pathVariables, List<DocumentedModelField> headers, List<DocumentedModelField> queryParameters, List<Map.Entry<String, List<DocumentedModelField>>> bodyParameters, String schema) {
        this.example = example;
        this.pathVariables = (List)Requires.require(pathVariables);
        this.headers = (List)Requires.require(headers);
        this.queryParameters = (List)Requires.require(queryParameters);
        this.bodyParameters = (List)Requires.require(bodyParameters);
        this.schema = schema;
    }

    public boolean isExamplePresent() {
        return this.example != null;
    }

    public String getExample() {
        return this.example;
    }

    public List<DocumentedModelField> getPathVariables() {
        return this.pathVariables;
    }

    public List<DocumentedModelField> getHeaders() {
        return this.headers;
    }

    public List<DocumentedModelField> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Map.Entry<String, List<DocumentedModelField>>> getBodyParameters() {
        return this.bodyParameters;
    }

    public boolean isSchemaPresent() {
        return this.schema != null;
    }

    public String getSchema() {
        return this.schema;
    }

    public static final class Builder {
        private String example;
        private List<DocumentedModelField> pathVariables = List.of();
        private List<DocumentedModelField> headers;
        private List<DocumentedModelField> queryParameters = List.of();
        private List<Map.Entry<String, List<DocumentedModelField>>> bodyParameters = List.of();
        private String schema;

        public Builder setExample(String example) {
            this.example = example;
            return this;
        }

        public Builder setPathVariables(List<DocumentedModelField> pathVariables) {
            this.pathVariables = pathVariables;
            return this;
        }

        public Builder setHeaders(List<DocumentedModelField> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setQueryParameters(List<DocumentedModelField> queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public Builder setBodyParameters(List<Map.Entry<String, List<DocumentedModelField>>> bodyParameters) {
            this.bodyParameters = bodyParameters;
            return this;
        }

        public Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public Request build() {
            return new Request(this.example, this.pathVariables, this.headers, this.queryParameters, this.bodyParameters, this.schema);
        }
    }
}

