/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.model;

import io.rxmicro.annotation.processor.common.model.DocumentStructure;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.config.DocumentationType;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.ResourceGroup;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Section;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.SectionType;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.documentation.DocumentationDefinition;
import io.rxmicro.documentation.IntroductionDefinition;
import io.rxmicro.documentation.asciidoctor.DocumentAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;

public final class AsciiDoctorDocumentStructure
extends DocumentStructure {
    private final ModuleElement currentModule;
    private final ProjectMetaData projectMetaData;
    private final DocumentAttributes documentAttributes;
    private final DocumentationDefinition documentationDefinition;
    private final List<ResourceGroup> resourceGroups;
    private final List<String> customSections;

    public AsciiDoctorDocumentStructure(ModuleElement currentModule, ProjectMetaData projectMetaData, DocumentAttributes documentAttributes, DocumentationDefinition documentationDefinition, List<ResourceGroup> resourceGroups, List<String> customSections) {
        this.currentModule = (ModuleElement)Requires.require((Object)currentModule);
        this.documentAttributes = (DocumentAttributes)Requires.require((Object)documentAttributes);
        this.documentationDefinition = (DocumentationDefinition)Requires.require((Object)documentationDefinition);
        this.projectMetaData = (ProjectMetaData)Requires.require((Object)projectMetaData);
        this.resourceGroups = (List)Requires.require(resourceGroups);
        this.customSections = (List)Requires.require(customSections);
    }

    public ModuleElement getCurrentModule() {
        return this.currentModule;
    }

    public DocumentationType getDocumentationType() {
        return DocumentationType.ASCII_DOCTOR;
    }

    public String getProjectDirectory() {
        return this.projectMetaData.getProjectDirectory();
    }

    public Optional<String> getCustomDestinationDirectory() {
        return Optional.of(this.documentationDefinition.destinationDirectory()).filter(v -> !v.isEmpty());
    }

    public String getName() {
        return Formats.format((String)"?Documentation.adoc", (Object[])new Object[]{this.projectMetaData.getName().replace(" ", "")});
    }

    public String getTemplateName() {
        return "documentation/asciidoctor/asciidoctor-document-template.adocftl";
    }

    public Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PROJECT", this.projectMetaData);
        map.put("WITH_TIPS", this.documentationDefinition.withTips());
        map.put("GENERATE_DATE", this.documentationDefinition.withGeneratedDate());
        map.put("DOCUMENT_ATTRIBUTES", this.getDocumentAttributes(this.currentModule, this.documentAttributes));
        IntroductionDefinition introductionDefinition = this.documentationDefinition.introduction();
        map.put("SECTIONS", this.getSections(introductionDefinition));
        map.put("RESOURCE_GROUPS", this.resourceGroups);
        return map;
    }

    private List<Map.Entry<String, String>> getDocumentAttributes(ModuleElement currentModule, DocumentAttributes documentAttributes) {
        String[] attrs = documentAttributes.value();
        if (attrs.length % 2 == 1) {
            throw new InterruptProcessingException((Element)currentModule, "Missing value for '?' attribute", new Object[]{attrs[attrs.length - 1]});
        }
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>();
        for (int i = 0; i < attrs.length; i += 2) {
            list.add(Map.entry(attrs[i], attrs[i + 1]));
        }
        return list;
    }

    private List<Section> getSections(IntroductionDefinition introductionDefinition) {
        ArrayList<Section> sections = new ArrayList<Section>();
        int index = 0;
        for (IntroductionDefinition.Section section : introductionDefinition.sectionOrder()) {
            if (section == IntroductionDefinition.Section.BASE_ENDPOINT) {
                if (this.projectMetaData.isBaseEndpointPresent()) {
                    sections.add(this.toSection(section, index));
                }
            } else {
                sections.add(this.toSection(section, index));
            }
            if (section != IntroductionDefinition.Section.CUSTOM_SECTION) continue;
            ++index;
        }
        return sections;
    }

    private Section toSection(IntroductionDefinition.Section section, int index) {
        if (section.isCustomSection()) {
            return new Section(SectionType.CUSTOM_TEXT, this.customSections.get(index));
        }
        String sectionName = section.name().toLowerCase(Locale.ENGLISH).replace("_", "-");
        return new Section(SectionType.INCLUDE_TEMPLATE, Formats.format((String)"introduction/?.adocftl", (Object[])new Object[]{sectionName}));
    }
}

