/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.primitive;

import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.ConstraintReader;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.meta.ReadMore;
import io.rxmicro.common.util.Formats;
import io.rxmicro.validation.constraint.Base64URLEncoded;
import io.rxmicro.validation.constraint.CountryCode;
import io.rxmicro.validation.constraint.DigitsOnly;
import io.rxmicro.validation.constraint.DomainName;
import io.rxmicro.validation.constraint.Email;
import io.rxmicro.validation.constraint.EndsWith;
import io.rxmicro.validation.constraint.HostName;
import io.rxmicro.validation.constraint.IP;
import io.rxmicro.validation.constraint.LatinAlphabetOnly;
import io.rxmicro.validation.constraint.Length;
import io.rxmicro.validation.constraint.Lowercase;
import io.rxmicro.validation.constraint.MaxLength;
import io.rxmicro.validation.constraint.MinLength;
import io.rxmicro.validation.constraint.Pattern;
import io.rxmicro.validation.constraint.Phone;
import io.rxmicro.validation.constraint.Skype;
import io.rxmicro.validation.constraint.StartsWith;
import io.rxmicro.validation.constraint.Telegram;
import io.rxmicro.validation.constraint.URI;
import io.rxmicro.validation.constraint.URLEncoded;
import io.rxmicro.validation.constraint.Uppercase;
import io.rxmicro.validation.constraint.Viber;
import io.rxmicro.validation.constraint.WhatsApp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class StringPrimitiveConstraintReader
extends ConstraintReader {
    private final List<ConstraintReader.AnnotationConstraintReader> annotationConstraintReaders = List.of((annotated, restrictions, readMores, descriptionBuilder) -> {
        Base64URLEncoded base64URLEncoded = (Base64URLEncoded)annotated.getAnnotation(Base64URLEncoded.class);
        if (base64URLEncoded != null && !base64URLEncoded.off()) {
            restrictions.add("format: base64Encoded");
            restrictions.add("alphabet: " + base64URLEncoded.alphabet());
            readMores.add(base64URLEncoded.alphabet().getReadMore());
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        CountryCode countryCode = (CountryCode)annotated.getAnnotation(CountryCode.class);
        if (countryCode != null && !countryCode.off()) {
            restrictions.add("format: countryCode");
            restrictions.add("ISO 3166-1: " + countryCode.format().getType());
            descriptionBuilder.append(countryCode.format().getDescription());
            readMores.add(countryCode.format().getReadMore());
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        DigitsOnly digitsOnly = (DigitsOnly)annotated.getAnnotation(DigitsOnly.class);
        if (digitsOnly != null && !digitsOnly.off()) {
            restrictions.add("format: digitsOnly");
            Annotations.getReadMore(DigitsOnly.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Email email = (Email)annotated.getAnnotation(Email.class);
        if (email != null && !email.off()) {
            restrictions.add("format: email");
            descriptionBuilder.append("Well-formed email address");
            Annotations.getReadMore(Email.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        HostName hostName = (HostName)annotated.getAnnotation(HostName.class);
        if (hostName != null && !hostName.off()) {
            restrictions.add("format: hostname");
            descriptionBuilder.append("Well-formed hostname");
            Annotations.getReadMore(HostName.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        DomainName domainName = (DomainName)annotated.getAnnotation(DomainName.class);
        if (domainName != null && !domainName.off()) {
            restrictions.add("format: domainName");
            descriptionBuilder.append("Well-formed domainName");
            Annotations.getReadMore(DomainName.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        IP ip = (IP)annotated.getAnnotation(IP.class);
        if (ip != null && !ip.off()) {
            IP.Version[] versions = ip.value();
            if (versions.length == 1) {
                restrictions.add("format: ip");
                restrictions.add("version: " + versions[0].getJsonFormat());
                descriptionBuilder.append("IP address of version ").append(versions[0].getVersion()).append('.');
                readMores.add(versions[0].getReadMore());
            } else {
                restrictions.add("format: ip");
                restrictions.add("version: [" + Arrays.stream(versions).map(IP.Version::getJsonFormat).collect(Collectors.joining(", ")) + "]");
                descriptionBuilder.append("IP address of version 4 or 6.");
                Arrays.stream(versions).forEach(v -> readMores.add(v.getReadMore()));
            }
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        LatinAlphabetOnly latinAlphabetOnly = (LatinAlphabetOnly)annotated.getAnnotation(LatinAlphabetOnly.class);
        if (latinAlphabetOnly != null && !latinAlphabetOnly.off()) {
            restrictions.add("alphabet: latinOnly");
            restrictions.add("allowsUppercase: " + latinAlphabetOnly.allowsUppercase());
            restrictions.add("allowsLowercase: " + latinAlphabetOnly.allowsLowercase());
            restrictions.add("allowsDigits: " + latinAlphabetOnly.allowsDigits());
            restrictions.add("allowsPunctuations: " + !latinAlphabetOnly.punctuations().isEmpty());
            Annotations.getReadMore(LatinAlphabetOnly.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Length length = (Length)annotated.getAnnotation(Length.class);
        if (length != null && !length.off()) {
            restrictions.add(Formats.format((String)"length: ?", (Object[])new Object[]{length.value()}));
            Annotations.getReadMore(Length.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Lowercase lowercase = (Lowercase)annotated.getAnnotation(Lowercase.class);
        if (lowercase != null && !lowercase.off()) {
            restrictions.add("lowercase: true");
            Annotations.getReadMore(Lowercase.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        MaxLength maxLength = (MaxLength)annotated.getAnnotation(MaxLength.class);
        if (maxLength != null && !maxLength.off()) {
            restrictions.add(Formats.format((String)"maxLength: ?", (Object[])new Object[]{maxLength.value()}));
            restrictions.add(Formats.format((String)"exclusiveMaximum: ?", (Object[])new Object[]{!maxLength.inclusive()}));
            Annotations.getReadMore(MaxLength.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        MinLength minLength = (MinLength)annotated.getAnnotation(MinLength.class);
        if (minLength != null && !minLength.off()) {
            restrictions.add(Formats.format((String)"minLength: ?", (Object[])new Object[]{minLength.value()}));
            restrictions.add(Formats.format((String)"exclusiveMinimum: ?", (Object[])new Object[]{!minLength.inclusive()}));
            Annotations.getReadMore(MinLength.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Pattern pattern = (Pattern)annotated.getAnnotation(Pattern.class);
        if (pattern != null && !pattern.off()) {
            restrictions.add("format: regex");
            restrictions.add(Formats.format((String)"pattern: /?/", (Object[])new Object[]{pattern.regexp()}));
            restrictions.add(Formats.format((String)"flags: ?", (Object[])new Object[]{Arrays.toString(pattern.flags())}));
            Annotations.getReadMore(Pattern.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Phone phone = (Phone)annotated.getAnnotation(Phone.class);
        if (phone != null && !phone.off()) {
            restrictions.add("format: phone number");
            descriptionBuilder.append("Phone number in the international format.");
            Annotations.getReadMore(Phone.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Skype skype = (Skype)annotated.getAnnotation(Skype.class);
        if (skype != null && !skype.off()) {
            restrictions.add("format: skype");
            descriptionBuilder.append("Skype name");
            Annotations.getReadMore(Skype.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Telegram telegram = (Telegram)annotated.getAnnotation(Telegram.class);
        if (telegram != null && !telegram.off()) {
            restrictions.add("format: telegram number");
            descriptionBuilder.append("Telegram number in the international format.");
            Annotations.getReadMore(Telegram.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Uppercase uppercase = (Uppercase)annotated.getAnnotation(Uppercase.class);
        if (uppercase != null && !uppercase.off()) {
            restrictions.add("uppercase: true");
            Annotations.getReadMore(Uppercase.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        URI uri = (URI)annotated.getAnnotation(URI.class);
        if (uri != null && !uri.off()) {
            restrictions.add("format: uri");
            Annotations.getReadMore(URI.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        URLEncoded urlEncoded = (URLEncoded)annotated.getAnnotation(URLEncoded.class);
        if (urlEncoded != null && !urlEncoded.off()) {
            restrictions.add("format: urlEncoded");
            Annotations.getReadMore(URLEncoded.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Viber viber = (Viber)annotated.getAnnotation(Viber.class);
        if (viber != null && !viber.off()) {
            restrictions.add("format: viber number");
            descriptionBuilder.append("Viber number in the international format.");
            Annotations.getReadMore(Viber.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        WhatsApp whatsApp = (WhatsApp)annotated.getAnnotation(WhatsApp.class);
        if (whatsApp != null && !whatsApp.off()) {
            restrictions.add("format: whatsapp number");
            descriptionBuilder.append("Whatsapp number in the international format.");
            Annotations.getReadMore(WhatsApp.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        StartsWith startsWith = (StartsWith)annotated.getAnnotation(StartsWith.class);
        if (startsWith != null && !startsWith.off()) {
            restrictions.add(Formats.format((String)"startsWith: '?'", (Object[])new Object[]{startsWith.value()}));
            Annotations.getReadMore(StartsWith.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        EndsWith endsWith = (EndsWith)annotated.getAnnotation(EndsWith.class);
        if (endsWith != null && !endsWith.off()) {
            restrictions.add(Formats.format((String)"endsWith: '?'", (Object[])new Object[]{endsWith.value()}));
            Annotations.getReadMore(EndsWith.class).ifPresent(readMores::add);
        }
    });

    @Override
    public void readIfConstraintEnabled(Map.Entry<RestModelField, ModelClass> entry, List<String> restrictions, List<ReadMore> readMores, StringBuilder descriptionBuilder) {
        RestModelField annotated = entry.getKey();
        if (Character.class.getName().equals(annotated.getFieldClass().toString())) {
            restrictions.add("format: character");
        }
        this.readUsingAnnotationConstraintReader(this.annotationConstraintReaders, annotated, restrictions, readMores, descriptionBuilder);
    }
}

