/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.primitive;

import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.Numbers;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.ConstraintReader;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.meta.ReadMore;
import io.rxmicro.common.util.Formats;
import io.rxmicro.validation.constraint.Lat;
import io.rxmicro.validation.constraint.Lng;
import io.rxmicro.validation.constraint.MaxDouble;
import io.rxmicro.validation.constraint.MaxInt;
import io.rxmicro.validation.constraint.MaxNumber;
import io.rxmicro.validation.constraint.MinDouble;
import io.rxmicro.validation.constraint.MinInt;
import io.rxmicro.validation.constraint.MinNumber;
import io.rxmicro.validation.constraint.Numeric;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

public final class NumberPrimitiveConstraintReader
extends ConstraintReader {
    private final List<ConstraintReader.AnnotationConstraintReader> annotationConstraintReaders = List.of((annotated, restrictions, readMores, descriptionBuilder) -> {
        Lat lat = (Lat)annotated.getAnnotation(Lat.class);
        if (lat != null && !lat.off()) {
            descriptionBuilder.append("Latitude of GPS location point.");
            Annotations.getReadMore(Lat.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Lng lng = (Lng)annotated.getAnnotation(Lng.class);
        if (lng != null && !lng.off()) {
            descriptionBuilder.append("Longitude of GPS location point.");
            Annotations.getReadMore(Lng.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        MinDouble minDouble = (MinDouble)annotated.getAnnotation(MinDouble.class);
        if (minDouble != null && !minDouble.off()) {
            restrictions.add(Formats.format((String)"minimum: ?", (Object[])new Object[]{this.formatNumber(minDouble.value())}));
            restrictions.add(Formats.format((String)"exclusiveMinimum: true", (Object[])new Object[0]));
            Annotations.getReadMore(MinDouble.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        MinInt minInt = (MinInt)annotated.getAnnotation(MinInt.class);
        if (minInt != null && !minInt.off()) {
            restrictions.add(Formats.format((String)"minimum: ?", (Object[])new Object[]{this.formatNumber(minInt.value())}));
            restrictions.add(Formats.format((String)("exclusiveMinimum: " + !minInt.inclusive()), (Object[])new Object[0]));
            Annotations.getReadMore(MinInt.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        MinNumber minNumber = (MinNumber)annotated.getAnnotation(MinNumber.class);
        if (minNumber != null && !minNumber.off()) {
            restrictions.add(Formats.format((String)"minimum: ?", (Object[])new Object[]{this.formatNumber(minNumber.value())}));
            restrictions.add(Formats.format((String)("exclusiveMinimum: " + !minNumber.inclusive()), (Object[])new Object[0]));
            Annotations.getReadMore(MinNumber.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        MaxDouble maxDouble = (MaxDouble)annotated.getAnnotation(MaxDouble.class);
        if (maxDouble != null && !maxDouble.off()) {
            restrictions.add(Formats.format((String)"maximum: ?", (Object[])new Object[]{this.formatNumber(maxDouble.value())}));
            restrictions.add(Formats.format((String)"exclusiveMaximum: true", (Object[])new Object[0]));
            Annotations.getReadMore(MaxDouble.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        MaxInt maxInt = (MaxInt)annotated.getAnnotation(MaxInt.class);
        if (maxInt != null && !maxInt.off()) {
            restrictions.add(Formats.format((String)"maximum: ?", (Object[])new Object[]{this.formatNumber(maxInt.value())}));
            restrictions.add(Formats.format((String)("exclusiveMaximum: " + !maxInt.inclusive()), (Object[])new Object[0]));
            Annotations.getReadMore(MaxInt.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        MaxNumber maxNumber = (MaxNumber)annotated.getAnnotation(MaxNumber.class);
        if (maxNumber != null && !maxNumber.off()) {
            restrictions.add(Formats.format((String)"maximum: ?", (Object[])new Object[]{this.formatNumber(maxNumber.value())}));
            restrictions.add(Formats.format((String)("exclusiveMaximum: " + !maxNumber.inclusive()), (Object[])new Object[0]));
            Annotations.getReadMore(MaxNumber.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Numeric numeric = (Numeric)annotated.getAnnotation(Numeric.class);
        if (numeric != null && !numeric.off()) {
            if (numeric.precision() > -1) {
                restrictions.add("precision: " + numeric.precision());
            }
            if (numeric.scale() > -1) {
                restrictions.add("scale: " + numeric.scale());
            }
            Annotations.getReadMore(Numeric.class).ifPresent(readMores::add);
        }
    });

    @Override
    public void readIfConstraintEnabled(Map.Entry<RestModelField, ModelClass> entry, List<String> restrictions, List<ReadMore> readMores, StringBuilder descriptionBuilder) {
        RestModelField annotated = entry.getKey();
        this.getNumberType(entry.getKey().getFieldClass()).ifPresent(t -> restrictions.add(Formats.format((String)"format: ?", (Object[])new Object[]{t})));
        this.readUsingAnnotationConstraintReader(this.annotationConstraintReaders, annotated, restrictions, readMores, descriptionBuilder);
    }

    private Optional<String> getNumberType(TypeMirror fieldClass) {
        return Optional.ofNullable((String)Numbers.NUMBER_FORMATS.get(fieldClass.toString()));
    }

    private String formatNumber(Number number) {
        return NumberFormat.getNumberInstance(Locale.ENGLISH).format(number);
    }

    private String formatNumber(String number) {
        return this.formatNumber(new BigDecimal(Numbers.removeUnderscoresIfPresent((String)number)));
    }
}

