/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.primitive;

import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.ConstraintReader;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.meta.ReadMore;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.common.util.Formats;
import io.rxmicro.validation.constraint.Enumeration;
import io.rxmicro.validation.constraint.SubEnum;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

public final class EnumPrimitiveConstraintReader
extends ConstraintReader {
    private static final String RESTRICTION_TEMPLATE = "enum: ?";
    private final List<ConstraintReader.AnnotationConstraintReader> annotationConstraintReaders = List.of((annotated, restrictions, readMores, descriptionBuilder) -> {
        Enumeration enumeration = (Enumeration)annotated.getAnnotation(Enumeration.class);
        if (enumeration != null && !enumeration.off()) {
            restrictions.add(Formats.format((String)RESTRICTION_TEMPLATE, (Object[])new Object[]{Arrays.toString(enumeration.value())}));
            Annotations.getReadMore(Enumeration.class).ifPresent(readMores::add);
        }
    });

    @Override
    public void readIfConstraintEnabled(Map.Entry<RestModelField, ModelClass> entry, List<String> restrictions, List<ReadMore> readMores, StringBuilder descriptionBuilder) {
        RestModelField annotated = entry.getKey();
        this.readUsingAnnotationConstraintReader(this.annotationConstraintReaders, annotated, restrictions, readMores, descriptionBuilder);
        if (entry.getValue().isEnum()) {
            Set enumConstants = Elements.getAllowedEnumConstants((TypeMirror)entry.getValue().asEnum().getTypeMirror());
            SubEnum subEnum = (SubEnum)annotated.getAnnotation(SubEnum.class);
            if (subEnum != null && !subEnum.off()) {
                if (subEnum.include().length > 0) {
                    restrictions.add(Formats.format((String)RESTRICTION_TEMPLATE, (Object[])new Object[]{Arrays.toString(subEnum.include())}));
                } else {
                    Set<String> excludes = Set.of(subEnum.exclude());
                    restrictions.add(Formats.format((String)RESTRICTION_TEMPLATE, (Object[])new Object[]{enumConstants.stream().filter(e -> !excludes.contains(e)).collect(ExCollectors.toOrderedSet())}));
                }
            } else {
                restrictions.add(Formats.format((String)RESTRICTION_TEMPLATE, (Object[])new Object[]{enumConstants}));
            }
        }
    }
}

