/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.primitive;

import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.ConstraintReader;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.ImpossibleException;
import io.rxmicro.common.meta.ReadMore;
import io.rxmicro.validation.constraint.Future;
import io.rxmicro.validation.constraint.FutureOrPresent;
import io.rxmicro.validation.constraint.Past;
import io.rxmicro.validation.constraint.PastOrPresent;
import io.rxmicro.validation.constraint.TruncatedTime;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class DateTimePrimitiveConstraintReader
extends ConstraintReader {
    private final List<ConstraintReader.AnnotationConstraintReader> annotationConstraintReaders = List.of((annotated, restrictions, readMores, descriptionBuilder) -> {
        Future future = (Future)annotated.getAnnotation(Future.class);
        if (future != null && !future.off()) {
            restrictions.add("future: true");
            Annotations.getReadMore(Future.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        FutureOrPresent futureOrPresent = (FutureOrPresent)annotated.getAnnotation(FutureOrPresent.class);
        if (futureOrPresent != null && !futureOrPresent.off()) {
            restrictions.add("future: true");
            restrictions.add("present: true");
            Annotations.getReadMore(FutureOrPresent.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Past past = (Past)annotated.getAnnotation(Past.class);
        if (past != null && !past.off()) {
            restrictions.add("past: true");
            Annotations.getReadMore(Past.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        PastOrPresent pastOrPresent = (PastOrPresent)annotated.getAnnotation(PastOrPresent.class);
        if (pastOrPresent != null && !pastOrPresent.off()) {
            restrictions.add("past: true");
            restrictions.add("present: true");
            Annotations.getReadMore(PastOrPresent.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        TruncatedTime truncatedTime = (TruncatedTime)annotated.getAnnotation(TruncatedTime.class);
        if (truncatedTime != null && !truncatedTime.off()) {
            restrictions.add("truncated: " + truncatedTime.value().name().toLowerCase(Locale.ENGLISH));
            Annotations.getReadMore(TruncatedTime.class).ifPresent(readMores::add);
        }
    });
    @ReadMore(caption="What is UTC?", link="https://en.wikipedia.org/wiki/Coordinated_Universal_Time")
    private Instant instant;

    @Override
    public void readIfConstraintEnabled(Map.Entry<RestModelField, ModelClass> entry, List<String> restrictions, List<ReadMore> readMores, StringBuilder descriptionBuilder) {
        RestModelField annotated = entry.getKey();
        this.addTypeFormat(restrictions, readMores, annotated);
        this.readUsingAnnotationConstraintReader(this.annotationConstraintReaders, annotated, restrictions, readMores, descriptionBuilder);
    }

    private void addTypeFormat(List<String> restrictions, List<ReadMore> readMores, RestModelField annotated) {
        if (Instant.class.getName().equals(annotated.getFieldClass().toString())) {
            restrictions.add("format: UTC");
            try {
                readMores.add(this.getClass().getDeclaredField("instant").getAnnotation(ReadMore.class));
            }
            catch (NoSuchFieldException ex) {
                throw new ImpossibleException((Throwable)ex, "Field `instant` must be declared!", new Object[0]);
            }
        }
    }
}

