/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions;

import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.ConstraintReader;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.meta.ReadMore;
import io.rxmicro.common.util.Formats;
import io.rxmicro.validation.constraint.MaxSize;
import io.rxmicro.validation.constraint.MinSize;
import io.rxmicro.validation.constraint.NullableArrayItem;
import io.rxmicro.validation.constraint.Size;
import io.rxmicro.validation.constraint.UniqueItems;
import java.util.List;
import java.util.Map;

public final class ArrayRestrictionReader
extends ConstraintReader {
    private final List<ConstraintReader.AnnotationConstraintReader> annotationConstraintReaders = List.of((annotated, restrictions, readMores, descriptionBuilder) -> {
        MaxSize maxSize = (MaxSize)annotated.getAnnotation(MaxSize.class);
        if (maxSize != null && !maxSize.off()) {
            restrictions.add(Formats.format((String)"maxSize: ?", (Object[])new Object[]{maxSize.value()}));
            restrictions.add(Formats.format((String)"exclusiveMaximum: ?", (Object[])new Object[]{!maxSize.inclusive()}));
            Annotations.getReadMore(MaxSize.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        MinSize minSize = (MinSize)annotated.getAnnotation(MinSize.class);
        if (minSize != null && !minSize.off()) {
            restrictions.add(Formats.format((String)"minSize: ?", (Object[])new Object[]{minSize.value()}));
            restrictions.add(Formats.format((String)"exclusiveMinimum: ?", (Object[])new Object[]{!minSize.inclusive()}));
            Annotations.getReadMore(MinSize.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        NullableArrayItem nonRequired = (NullableArrayItem)annotated.getAnnotation(NullableArrayItem.class);
        if (nonRequired != null && !nonRequired.off()) {
            restrictions.add("optionalItem: true");
            Annotations.getReadMore(NullableArrayItem.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        Size size = (Size)annotated.getAnnotation(Size.class);
        if (size != null && !size.off()) {
            restrictions.add(Formats.format((String)"size: ?", (Object[])new Object[]{size.value()}));
            Annotations.getReadMore(Size.class).ifPresent(readMores::add);
        }
    }, (annotated, restrictions, readMores, descriptionBuilder) -> {
        UniqueItems uniqueItems = (UniqueItems)annotated.getAnnotation(UniqueItems.class);
        if (uniqueItems != null && !uniqueItems.off()) {
            restrictions.add("uniqueItems: true");
            Annotations.getReadMore(UniqueItems.class).ifPresent(readMores::add);
        }
    });

    @Override
    public void readIfConstraintEnabled(Map.Entry<RestModelField, ModelClass> entry, List<String> restrictions, List<ReadMore> readMores, StringBuilder descriptionBuilder) {
        RestModelField annotated = entry.getKey();
        this.readUsingAnnotationConstraintReader(this.annotationConstraintReaders, annotated, restrictions, readMores, descriptionBuilder);
    }

    public void read(Map.Entry<RestModelField, ModelClass> entry, List<String> restrictions, List<ReadMore> readMores) {
        RestModelField annotated = entry.getKey();
        this.readUsingAnnotationConstraintReader(this.annotationConstraintReaders, annotated, restrictions, readMores, null);
    }
}

