/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.DocumentedModelFieldBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.SimpleErrorResponseBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.AbstractErrorResponseBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.DocumentedModelField;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Response;
import io.rxmicro.annotation.processor.documentation.component.DescriptionReader;
import io.rxmicro.annotation.processor.documentation.model.AnnotationValueProvider;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.annotation.processor.documentation.model.ReadMoreModel;
import io.rxmicro.annotation.processor.documentation.model.StandardHttpErrorStorage;
import io.rxmicro.annotation.processor.documentation.model.provider.SimpleErrorResponseHeaderNamesAnnotationValueProvider;
import io.rxmicro.annotation.processor.documentation.model.provider.SimpleErrorResponseHeaderValueExamplesAnnotationValueProvider;
import io.rxmicro.annotation.processor.documentation.model.provider.SimpleErrorResponseParamNamesAnnotationValueProvider;
import io.rxmicro.annotation.processor.documentation.model.provider.SimpleErrorResponseParamValueExamplesAnnotationValueProvider;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Formats;
import io.rxmicro.documentation.ResourceDefinition;
import io.rxmicro.documentation.SimpleErrorResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;

@Singleton
public final class SimpleErrorResponseBuilderImpl
extends AbstractErrorResponseBuilder
implements SimpleErrorResponseBuilder {
    @Inject
    private DescriptionReader descriptionReader;
    @Inject
    private StandardHttpErrorStorage standardHttpErrorStorage;

    @Override
    public Response buildResponse(Element owner, ProjectMetaData projectMetaData, ResourceDefinition resourceDefinition, SimpleErrorResponse simpleErrorResponse, List<ReadMoreModel> showErrorCauseReadMoreLinks) {
        this.validate(owner, simpleErrorResponse);
        int status = simpleErrorResponse.status();
        Response.Builder responseBuilder = new Response.Builder().setCode(status);
        this.descriptionReader.readDescription(owner, projectMetaData.getProjectDirectory(), simpleErrorResponse).ifPresentOrElse(responseBuilder::setDescription, () -> this.standardHttpErrorStorage.get(status).ifPresent(e -> responseBuilder.setDescription(e.getDescription())));
        Map<String, String> errorHeaders = this.getErrorHeaders(owner, simpleErrorResponse);
        Map<String, String> errorParams = this.getErrorParams(owner, simpleErrorResponse);
        if (resourceDefinition.withExamples()) {
            responseBuilder.setExample(this.httpResponseExampleBuilder.buildErrorExample(resourceDefinition, status, errorHeaders, errorParams));
        }
        if (resourceDefinition.withHeadersDescriptionTable()) {
            this.setHeadersIfFound(responseBuilder, simpleErrorResponse, errorHeaders, resourceDefinition.withRequestIdResponseHeader());
        }
        if (resourceDefinition.withBodyParametersDescriptionTable()) {
            this.setBodyParametersIfFound(responseBuilder, simpleErrorResponse, errorParams);
        }
        return responseBuilder.build();
    }

    private void validate(Element owner, SimpleErrorResponse simpleErrorResponse) {
        if (simpleErrorResponse.paramNames().length != simpleErrorResponse.paramValueExamples().length) {
            throw new InterruptProcessingException(owner, "Invalid parameters for '@?' annotation: paramNames().length must be equal to paramValueExamples().length!", new Object[]{SimpleErrorResponse.class.getSimpleName()});
        }
        if (simpleErrorResponse.headerNames().length != simpleErrorResponse.headerValueExamples().length) {
            throw new InterruptProcessingException(owner, "Invalid parameters for '@?' annotation: headerNames().length must be equal to headerValueExamples().length!", new Object[]{SimpleErrorResponse.class.getSimpleName()});
        }
        Map.of("paramNames", simpleErrorResponse.paramNames(), "headerNames", simpleErrorResponse.headerNames()).forEach((name, array) -> {
            for (String value : array) {
                if (!value.isBlank()) continue;
                throw new InterruptProcessingException(owner, "The blank value is not allowed for '@?.?' parameter! Provide correct value!", new Object[]{SimpleErrorResponse.class.getSimpleName(), name});
            }
        });
    }

    private Map<String, String> getErrorHeaders(Element owner, SimpleErrorResponse simpleErrorResponse) {
        return this.getValueMap(owner, simpleErrorResponse.headerNames().length, (AnnotationValueProvider)new SimpleErrorResponseHeaderNamesAnnotationValueProvider(simpleErrorResponse), (AnnotationValueProvider)new SimpleErrorResponseHeaderValueExamplesAnnotationValueProvider(simpleErrorResponse));
    }

    private Map<String, String> getErrorParams(Element owner, SimpleErrorResponse simpleErrorResponse) {
        return this.getValueMap(owner, simpleErrorResponse.paramNames().length, (AnnotationValueProvider)new SimpleErrorResponseParamNamesAnnotationValueProvider(simpleErrorResponse), (AnnotationValueProvider)new SimpleErrorResponseParamValueExamplesAnnotationValueProvider(simpleErrorResponse));
    }

    private Map<String, String> getValueMap(Element owner, int count, AnnotationValueProvider namesProvider, AnnotationValueProvider valueExamplesProvider) {
        if (count > 0) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < count; ++i) {
                map.put(this.resolveString(owner, namesProvider, false), this.resolveString(owner, valueExamplesProvider, false));
            }
            return ExCollections.unmodifiableOrderedMap(map);
        }
        return Map.of();
    }

    private void setHeadersIfFound(Response.Builder responseBuilder, SimpleErrorResponse annotation, Map<String, String> errorHeaders, boolean withRequestIdHeader) {
        ArrayList<DocumentedModelField> documentedModelFields = new ArrayList<DocumentedModelField>();
        if (withRequestIdHeader && errorHeaders.keySet().stream().noneMatch(h -> h.equalsIgnoreCase("Request-Id"))) {
            documentedModelFields.add(DocumentedModelFieldBuilder.buildRequestIdHeaderDocumentedModelField(true));
        }
        int index = 0;
        for (Map.Entry<String, String> entry : errorHeaders.entrySet()) {
            boolean required = index >= annotation.headersRequired().length || annotation.headersRequired()[index];
            boolean withDesc = index < annotation.headerDescriptions().length && !annotation.headerDescriptions()[index].isBlank();
            documentedModelFields.add(new DocumentedModelField(entry.getKey(), this.resolveValueType(entry.getValue()), List.of(required ? "required: true" : "optional: true"), withDesc ? annotation.headerDescriptions()[index] : Formats.format((String)"'?' header", (Object[])new Object[]{entry.getKey()}), List.of()));
            ++index;
        }
        if (!documentedModelFields.isEmpty()) {
            responseBuilder.setHeaders(documentedModelFields);
        }
    }

    private void setBodyParametersIfFound(Response.Builder responseBuilder, SimpleErrorResponse annotation, Map<String, String> errorParams) {
        if (!errorParams.isEmpty()) {
            ArrayList<DocumentedModelField> documentedModelFields = new ArrayList<DocumentedModelField>(errorParams.size());
            int index = 0;
            for (Map.Entry<String, String> entry : errorParams.entrySet()) {
                boolean required = index >= annotation.paramsRequired().length || annotation.paramsRequired()[index];
                boolean withDesc = index < annotation.paramDescriptions().length && !annotation.paramDescriptions()[index].isBlank();
                documentedModelFields.add(new DocumentedModelField(entry.getKey(), this.resolveValueType(entry.getValue()), List.of(required ? "required: true" : "optional: true"), withDesc ? annotation.paramDescriptions()[index] : Formats.format((String)"'?' parameter", (Object[])new Object[]{entry.getKey()}), List.of()));
                ++index;
            }
            responseBuilder.setParameters(List.of(Map.entry("Body", documentedModelFields)));
        }
    }

    private String resolveValueType(String value) {
        if ("true".equals(value) || "false".equals(value)) {
            return "boolean";
        }
        try {
            new BigDecimal(value);
            return "number";
        }
        catch (NumberFormatException ignore) {
            return "string";
        }
    }
}

