/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.DocumentedModelFieldBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.ModelExceptionErrorResponseBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.ResponsesBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.SimpleErrorResponseBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.DocumentedModelField;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Response;
import io.rxmicro.annotation.processor.documentation.component.DescriptionReader;
import io.rxmicro.annotation.processor.documentation.component.HttpResponseExampleBuilder;
import io.rxmicro.annotation.processor.documentation.component.JsonSchemaBuilder;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.annotation.processor.documentation.model.ReadMoreModel;
import io.rxmicro.annotation.processor.documentation.model.StandardHttpError;
import io.rxmicro.annotation.processor.documentation.model.StandardHttpErrorStorage;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.server.model.AbstractRestControllerModelClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethod;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.documentation.DocumentationDefinition;
import io.rxmicro.documentation.IntroductionDefinition;
import io.rxmicro.documentation.ModelExceptionErrorResponse;
import io.rxmicro.documentation.ResourceDefinition;
import io.rxmicro.documentation.SimpleErrorResponse;
import io.rxmicro.json.JsonHelper;
import io.rxmicro.rest.model.HttpModelType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Singleton
public final class ResponsesBuilderImpl
implements ResponsesBuilder {
    @Inject
    private DocumentedModelFieldBuilder documentedModelFieldBuilder;
    @Inject
    private JsonSchemaBuilder jsonSchemaBuilder;
    @Inject
    private HttpResponseExampleBuilder httpResponseExampleBuilder;
    @Inject
    private DescriptionReader descriptionReader;
    @Inject
    private SimpleErrorResponseBuilder simpleErrorResponseBuilder;
    @Inject
    private ModelExceptionErrorResponseBuilder modelExceptionErrorResponseBuilder;
    @Inject
    private StandardHttpErrorStorage standardHttpErrorStorage;

    @Override
    public Response buildSuccessResponse(ResourceDefinition resourceDefinition, ProjectMetaData projectMetaData, EnvironmentContext environmentContext, RestControllerMethod method, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        int code = method.getSuccessStatusCode();
        Response.Builder responseBuilder = new Response.Builder().setCode(code);
        if (resourceDefinition.withExamples()) {
            responseBuilder.setExample(this.httpResponseExampleBuilder.build(resourceDefinition, restControllerClassStructureStorage, method));
        }
        Optional<RestObjectModelClass> responseModelClass = this.getResponseModelClass(method, restControllerClassStructureStorage);
        return responseModelClass.map(cl -> {
            if (resourceDefinition.withJsonSchema()) {
                responseBuilder.setSchema(JsonHelper.toJsonString((Map)this.jsonSchemaBuilder.getJsonObjectSchema(environmentContext, projectMetaData.getProjectDirectory(), cl), (boolean)true));
            }
            this.descriptionReader.readDescription((Element)cl.getModelTypeElement(), projectMetaData.getProjectDirectory()).ifPresent(responseBuilder::setDescription);
            boolean withReadMore = resourceDefinition.withReadMore();
            return responseBuilder.setHeaders(resourceDefinition.withHeadersDescriptionTable() ? this.buildResponseHeaders(environmentContext, resourceDefinition, projectMetaData, (RestObjectModelClass)cl, withReadMore) : List.of()).setParameters(resourceDefinition.withBodyParametersDescriptionTable() ? this.documentedModelFieldBuilder.buildComplex(environmentContext, resourceDefinition.withStandardDescriptions(), projectMetaData.getProjectDirectory(), (RestObjectModelClass)cl, HttpModelType.PARAMETER, withReadMore) : List.of()).build();
        }).orElseGet(responseBuilder::build);
    }

    @Override
    public Set<Response> buildErrorResponses(EnvironmentContext environmentContext, ProjectMetaData projectMetaData, DocumentationDefinition documentationDefinition, ResourceDefinition resourceDefinition, RestControllerClassStructure classStructure, RestControllerMethod method) {
        List<ReadMoreModel> showErrorCauseReadMoreLinks = this.getShowErrorCauseReadMoreLinks(documentationDefinition, resourceDefinition);
        TreeSet<Response> responses = new TreeSet<Response>();
        TypeElement ownerClass = classStructure.getOwnerClass();
        Arrays.stream((ModelExceptionErrorResponse[])method.getMethod().getAnnotationsByType(ModelExceptionErrorResponse.class)).forEach(e -> responses.add(this.modelExceptionErrorResponseBuilder.buildResponse(environmentContext, method.getMethod(), projectMetaData, resourceDefinition, (ModelExceptionErrorResponse)e, showErrorCauseReadMoreLinks)));
        Arrays.stream((SimpleErrorResponse[])method.getMethod().getAnnotationsByType(SimpleErrorResponse.class)).forEach(e -> responses.add(this.simpleErrorResponseBuilder.buildResponse(method.getMethod(), projectMetaData, resourceDefinition, (SimpleErrorResponse)e, showErrorCauseReadMoreLinks)));
        Arrays.stream((ModelExceptionErrorResponse[])ownerClass.getAnnotationsByType(ModelExceptionErrorResponse.class)).forEach(e -> responses.add(this.modelExceptionErrorResponseBuilder.buildResponse(environmentContext, ownerClass, projectMetaData, resourceDefinition, (ModelExceptionErrorResponse)e, showErrorCauseReadMoreLinks)));
        Arrays.stream((SimpleErrorResponse[])ownerClass.getAnnotationsByType(SimpleErrorResponse.class)).forEach(e -> responses.add(this.simpleErrorResponseBuilder.buildResponse(ownerClass, projectMetaData, resourceDefinition, (SimpleErrorResponse)e, showErrorCauseReadMoreLinks)));
        if (environmentContext.isRxMicroModuleEnabled(RxMicroModule.RX_MICRO_VALIDATION_MODULE) && resourceDefinition.withValidationResponse() && method.getFromHttpDataType().isPresent()) {
            responses.add(this.addValidationErrorResponse(resourceDefinition));
        }
        if (resourceDefinition.withInternalErrorResponse()) {
            responses.add(this.addInternalErrorResponse(resourceDefinition, showErrorCauseReadMoreLinks));
        }
        return responses;
    }

    private List<DocumentedModelField> buildResponseHeaders(EnvironmentContext environmentContext, ResourceDefinition resourceDefinition, ProjectMetaData projectMetaData, RestObjectModelClass cl, boolean withReadMore) {
        if (resourceDefinition.withRequestIdResponseHeader()) {
            List<DocumentedModelField> headers = this.documentedModelFieldBuilder.buildSimple(environmentContext, resourceDefinition.withStandardDescriptions(), projectMetaData.getProjectDirectory(), cl, HttpModelType.HEADER, withReadMore);
            if (headers.stream().noneMatch(f -> f.getName().equalsIgnoreCase("Request-Id"))) {
                headers.add(0, DocumentedModelFieldBuilder.buildRequestIdHeaderDocumentedModelField(true));
            }
            return headers;
        }
        return this.documentedModelFieldBuilder.buildSimple(environmentContext, resourceDefinition.withStandardDescriptions(), projectMetaData.getProjectDirectory(), cl, HttpModelType.HEADER, withReadMore);
    }

    private Optional<RestObjectModelClass> getResponseModelClass(RestControllerMethod method, RestControllerClassStructureStorage storage) {
        return method.getToHttpDataType().flatMap(t -> storage.getModelWriterClassStructure(t.asType().toString())).map(AbstractRestControllerModelClassStructure::getModelClass);
    }

    private List<ReadMoreModel> getShowErrorCauseReadMoreLinks(DocumentationDefinition documentationDefinition, ResourceDefinition resourceDefinition) {
        if (resourceDefinition.withReadMore() && Arrays.stream(documentationDefinition.introduction().sectionOrder()).anyMatch(s -> s == IntroductionDefinition.Section.ERROR_MODEL) && Arrays.stream(documentationDefinition.output()).noneMatch(o -> DocumentationDefinition.GenerationOutput.RESOURCES_SECTION == o)) {
            return List.of(new ReadMoreModel("_(How to activate the displaying of the detailed error message?)_", "internal-error-message-read-more", true));
        }
        return List.of();
    }

    private Response addValidationErrorResponse(ResourceDefinition resourceDefinition) {
        return this.addErrorResponse(resourceDefinition, (StandardHttpError)this.standardHttpErrorStorage.get(400).orElseThrow(Errors.createInternalErrorSupplier((String)"Standard http error not defined for 400 status code", (Object[])new Object[0])), List.of());
    }

    private Response addInternalErrorResponse(ResourceDefinition resourceDefinition, List<ReadMoreModel> showErrorCauseReadMoreLinks) {
        return this.addErrorResponse(resourceDefinition, (StandardHttpError)this.standardHttpErrorStorage.get(500).orElseThrow(Errors.createInternalErrorSupplier((String)"Standard http error not defined for 500 status code", (Object[])new Object[0])), showErrorCauseReadMoreLinks);
    }

    private Response addErrorResponse(ResourceDefinition resourceDefinition, StandardHttpError standardHttpError, List<ReadMoreModel> readMoreLinks) {
        int status = standardHttpError.getStatus();
        Response.Builder responseBuilder = new Response.Builder().setCode(status).setDescription(standardHttpError.getDescription());
        if (resourceDefinition.withExamples()) {
            responseBuilder.setExample(this.httpResponseExampleBuilder.buildErrorExample(resourceDefinition, status, standardHttpError.getExampleErrorMessage()));
        }
        if (resourceDefinition.withHeadersDescriptionTable() && resourceDefinition.withRequestIdResponseHeader()) {
            responseBuilder.setHeaders(List.of(DocumentedModelFieldBuilder.buildRequestIdHeaderDocumentedModelField(true)));
        }
        if (resourceDefinition.withBodyParametersDescriptionTable()) {
            responseBuilder.setParameters(List.of(Map.entry("Body", List.of(new DocumentedModelField("message", "string", List.of("required: true"), standardHttpError.getMessageDescription(), readMoreLinks)))));
        }
        return responseBuilder.build();
    }
}

