/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.DocumentedModelFieldBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.RequestBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.DocumentedModelField;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Request;
import io.rxmicro.annotation.processor.documentation.component.HttpRequestExampleBuilder;
import io.rxmicro.annotation.processor.documentation.component.JsonSchemaBuilder;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.server.model.AbstractRestControllerModelClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethod;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.documentation.ResourceDefinition;
import io.rxmicro.json.JsonHelper;
import io.rxmicro.rest.model.HttpModelType;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

@Singleton
public final class RequestBuilderImpl
implements RequestBuilder {
    @Inject
    private DocumentedModelFieldBuilder documentedModelFieldBuilder;
    @Inject
    private JsonSchemaBuilder jsonSchemaBuilder;
    @Inject
    private HttpRequestExampleBuilder httpRequestExampleBuilder;

    @Override
    public Request buildRequest(EnvironmentContext environmentContext, ProjectMetaData projectMetaData, ResourceDefinition resourceDefinition, RestControllerClassStructure classStructure, HttpMethodMapping httpMethodMapping, RestControllerMethod method, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        Request.Builder builder = new Request.Builder();
        if (resourceDefinition.withExamples()) {
            builder.setExample(this.httpRequestExampleBuilder.build(projectMetaData, classStructure.getParentUrl(), httpMethodMapping, restControllerClassStructureStorage, method));
        }
        Optional<RestObjectModelClass> requestModelClass = this.getRequestModelClass(method, restControllerClassStructureStorage);
        return requestModelClass.map(cl -> {
            this.setHeadersAndPathVariables(environmentContext, projectMetaData, resourceDefinition, classStructure, (RestObjectModelClass)cl, builder);
            this.setParameters(environmentContext, projectMetaData, resourceDefinition, httpMethodMapping, (RestObjectModelClass)cl, builder);
            return builder.build();
        }).orElseGet(() -> builder.setHeaders(classStructure.getParentUrl().isHeaderVersionStrategy() ? List.of(this.getApiVersionDocumentedModelField(classStructure.getParentUrl())) : List.of()).build());
    }

    private void setHeadersAndPathVariables(EnvironmentContext environmentContext, ProjectMetaData projectMetaData, ResourceDefinition resourceDefinition, RestControllerClassStructure classStructure, RestObjectModelClass restObjectModelClass, Request.Builder builder) {
        boolean withReadMore = resourceDefinition.withReadMore();
        builder.setHeaders(this.getHeaders(environmentContext, resourceDefinition, projectMetaData, classStructure, restObjectModelClass, withReadMore));
        if (resourceDefinition.withPathVariablesDescriptionTable()) {
            builder.setPathVariables(this.documentedModelFieldBuilder.buildSimple(environmentContext, resourceDefinition.withStandardDescriptions(), projectMetaData.getProjectDirectory(), restObjectModelClass, HttpModelType.PATH, withReadMore));
        }
    }

    private void setParameters(EnvironmentContext environmentContext, ProjectMetaData projectMetaData, ResourceDefinition resourceDefinition, HttpMethodMapping httpMethodMapping, RestObjectModelClass restObjectModelClass, Request.Builder builder) {
        boolean withReadMore = resourceDefinition.withReadMore();
        if (!httpMethodMapping.isHttpBody()) {
            if (resourceDefinition.withQueryParametersDescriptionTable()) {
                builder.setQueryParameters(this.documentedModelFieldBuilder.buildSimple(environmentContext, resourceDefinition.withStandardDescriptions(), projectMetaData.getProjectDirectory(), restObjectModelClass, HttpModelType.PARAMETER, withReadMore));
            }
        } else {
            if (resourceDefinition.withBodyParametersDescriptionTable()) {
                builder.setBodyParameters(this.documentedModelFieldBuilder.buildComplex(environmentContext, resourceDefinition.withStandardDescriptions(), projectMetaData.getProjectDirectory(), restObjectModelClass, HttpModelType.PARAMETER, withReadMore));
            }
            if (resourceDefinition.withJsonSchema()) {
                builder.setSchema(JsonHelper.toJsonString((Map)this.jsonSchemaBuilder.getJsonObjectSchema(environmentContext, projectMetaData.getProjectDirectory(), restObjectModelClass), (boolean)true));
            }
        }
    }

    private List<DocumentedModelField> getHeaders(EnvironmentContext environmentContext, ResourceDefinition resourceDefinition, ProjectMetaData projectMetaData, RestControllerClassStructure classStructure, RestObjectModelClass restObjectModelClass, boolean withReadMore) {
        return new ArrayList<DocumentedModelField>((Collection)Stream.concat(classStructure.getParentUrl().isHeaderVersionStrategy() ? Stream.of(this.getApiVersionDocumentedModelField(classStructure.getParentUrl())) : Stream.of(new DocumentedModelField[0]), resourceDefinition.withHeadersDescriptionTable() ? this.documentedModelFieldBuilder.buildSimple(environmentContext, resourceDefinition.withStandardDescriptions(), projectMetaData.getProjectDirectory(), restObjectModelClass, HttpModelType.HEADER, withReadMore).stream() : Stream.of(new DocumentedModelField[0])).collect(ExCollectors.toOrderedSet()));
    }

    private DocumentedModelField getApiVersionDocumentedModelField(ParentUrl parentUrl) {
        List<CallSite> restrictions = List.of("required: true", "expected: " + parentUrl.getVersionValue());
        String description = "Api version required header, value of which is used by the RxMicro framework framework to define appropriate request handler.";
        return new DocumentedModelField(parentUrl.getVersionHeaderName(), "string", restrictions, "Api version required header, value of which is used by the RxMicro framework framework to define appropriate request handler.", List.of());
    }

    private Optional<RestObjectModelClass> getRequestModelClass(RestControllerMethod method, RestControllerClassStructureStorage storage) {
        return method.getFromHttpDataType().flatMap(t -> storage.getModelReaderClassStructure(t.asType().toString())).map(AbstractRestControllerModelClassStructure::getModelClass);
    }
}

