/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.AbstractErrorResponseBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Response;
import io.rxmicro.annotation.processor.documentation.model.AnnotationValueProvider;
import io.rxmicro.annotation.processor.documentation.model.ReadMoreModel;
import io.rxmicro.annotation.processor.documentation.model.StandardHttpError;
import io.rxmicro.annotation.processor.documentation.model.StandardHttpErrorStorage;
import io.rxmicro.annotation.processor.documentation.model.provider.DescriptionAnnotationValueProvider;
import io.rxmicro.annotation.processor.documentation.model.provider.ExampleAnnotationValueProvider;
import io.rxmicro.documentation.Description;
import io.rxmicro.documentation.Example;
import io.rxmicro.documentation.ResourceDefinition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class ModelExceptionErrorResponseStandardBuilder
extends AbstractErrorResponseBuilder {
    @Inject
    private StandardHttpErrorStorage standardHttpErrorStorage;

    void setResponseBodyAndExamples(Element owner, ResourceDefinition resourceDefinition, List<ReadMoreModel> showErrorCauseReadMoreLinks, TypeElement exceptionTypeElement, int status, Response.Builder responseBuilder) {
        Map.Entry<String, String> entry = this.getExampleErrorMessageWithDescription(owner, exceptionTypeElement, status);
        String exampleErrorMessage = entry.getKey();
        if (resourceDefinition.withExamples()) {
            this.setResponseExample(resourceDefinition, exampleErrorMessage, status, responseBuilder);
        }
        if (resourceDefinition.withBodyParametersDescriptionTable() && !exampleErrorMessage.isEmpty()) {
            boolean showReadMoreLinks = this.standardHttpErrorStorage.get(status).map(StandardHttpError::isWithShowErrorCauseReadMoreLink).orElse(false);
            String messageDescription = entry.getValue();
            this.setBodyParameter(messageDescription, responseBuilder, showReadMoreLinks ? showErrorCauseReadMoreLinks : List.of());
        }
    }

    private Map.Entry<String, String> getExampleErrorMessageWithDescription(Element owner, TypeElement exceptionTypeElement, int status) {
        List constructors = Elements.allConstructors((TypeElement)exceptionTypeElement);
        if (constructors.size() != 1) {
            throw new InterruptProcessingException(owner, "'?' model exception class must declare only one constructor", new Object[]{exceptionTypeElement.asType().toString()});
        }
        Optional<VariableElement> messageParameterOptional = this.getMessageParameter((ExecutableElement)constructors.get(0));
        if (messageParameterOptional.isPresent()) {
            String exampleErrorMessage = Optional.ofNullable(messageParameterOptional.get().getAnnotation(Example.class)).map(a -> this.resolveString(owner, (AnnotationValueProvider)new ExampleAnnotationValueProvider(a), false)).orElseGet(() -> this.standardHttpErrorStorage.get(status).map(StandardHttpError::getExampleErrorMessage).orElse(""));
            String messageDescription = Optional.ofNullable(messageParameterOptional.get().getAnnotation(Description.class)).map(a -> this.resolveString(owner, (AnnotationValueProvider)new DescriptionAnnotationValueProvider(a), false)).orElseGet(() -> this.standardHttpErrorStorage.get(status).map(StandardHttpError::getMessageDescription).orElse(""));
            return Map.entry(exampleErrorMessage, messageDescription);
        }
        return Map.entry("", "");
    }

    private Optional<VariableElement> getMessageParameter(ExecutableElement executableElement) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() == 1 && String.class.getName().equals(parameters.get(0).asType().toString())) {
            return Optional.of(parameters.get(0));
        }
        if (parameters.size() == 2 && String.class.getName().equals(parameters.get(0).asType().toString()) && executableElement.isVarArgs()) {
            return Optional.of(parameters.get(0));
        }
        return Optional.empty();
    }
}

