/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.ModelFieldBuilder;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.ModelExceptionErrorResponseBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.ModelExceptionErrorResponseCustomBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.ModelExceptionErrorResponseStandardBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Response;
import io.rxmicro.annotation.processor.documentation.component.DescriptionReader;
import io.rxmicro.annotation.processor.documentation.component.HttpResponseExampleBuilder;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.annotation.processor.documentation.model.ReadMoreModel;
import io.rxmicro.annotation.processor.documentation.model.StandardHttpErrorStorage;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.common.local.DeniedPackages;
import io.rxmicro.documentation.ModelExceptionErrorResponse;
import io.rxmicro.documentation.ResourceDefinition;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

@Singleton
public final class ModelExceptionErrorResponseBuilderImpl
implements ModelExceptionErrorResponseBuilder {
    @Inject
    private DescriptionReader descriptionReader;
    @Inject
    private StandardHttpErrorStorage standardHttpErrorStorage;
    @Inject
    private ModelFieldBuilder<RestModelField, RestObjectModelClass> modelFieldBuilder;
    @Inject
    private ModelExceptionErrorResponseStandardBuilder modelExceptionErrorResponseStandardBuilder;
    @Inject
    private ModelExceptionErrorResponseCustomBuilder modelExceptionErrorResponseCustomBuilder;
    @Inject
    private HttpResponseExampleBuilder httpResponseExampleBuilder;

    @Override
    public Response buildResponse(EnvironmentContext environmentContext, Element owner, ProjectMetaData projectMetaData, ResourceDefinition resourceDefinition, ModelExceptionErrorResponse modelExceptionErrorResponse, List<ReadMoreModel> showErrorCauseReadMoreLinks) {
        TypeElement exceptionTypeElement = Annotations.getRequiredAnnotationClassParameter(() -> ((ModelExceptionErrorResponse)modelExceptionErrorResponse).value());
        int status = this.extractStatusCode(owner, exceptionTypeElement);
        Response.Builder responseBuilder = new Response.Builder().setCode(status);
        this.descriptionReader.readDescription((Element)exceptionTypeElement, projectMetaData.getProjectDirectory()).ifPresentOrElse(responseBuilder::setDescription, () -> this.standardHttpErrorStorage.get(status).ifPresent(e -> responseBuilder.setDescription(e.getDescription())));
        if (this.isRxMicroExceptionClass(exceptionTypeElement)) {
            this.modelExceptionErrorResponseStandardBuilder.setResponseBodyAndExamples(owner, resourceDefinition, showErrorCauseReadMoreLinks, exceptionTypeElement, status, responseBuilder);
        } else {
            RestObjectModelClass modelClass = this.getModelClass(environmentContext, exceptionTypeElement);
            if (resourceDefinition.withExamples()) {
                responseBuilder.setExample(this.httpResponseExampleBuilder.build(resourceDefinition, status, modelClass));
            }
            this.modelExceptionErrorResponseCustomBuilder.setResponseHeaders(environmentContext, resourceDefinition, projectMetaData, modelClass, responseBuilder);
            if (this.isCustomParamsPresent(exceptionTypeElement)) {
                this.modelExceptionErrorResponseCustomBuilder.setResponseBody(environmentContext, resourceDefinition, projectMetaData, modelClass, responseBuilder);
            } else {
                this.modelExceptionErrorResponseStandardBuilder.setResponseBodyAndExamples(owner, resourceDefinition, showErrorCauseReadMoreLinks, exceptionTypeElement, status, responseBuilder);
            }
        }
        return responseBuilder.build();
    }

    private int extractStatusCode(Element owner, TypeElement exceptionTypeElement) {
        Predicate<VariableElement> variableElementPredicate = el -> el.getModifiers().containsAll(Set.of(Modifier.STATIC, Modifier.FINAL)) && "STATUS_CODE".equals(el.getSimpleName().toString()) && el.asType().getKind() == TypeKind.INT;
        return (Integer)((VariableElement)Elements.allFields((TypeElement)exceptionTypeElement, variableElementPredicate).stream().findFirst().orElseThrow(() -> {
            throw new InterruptProcessingException(owner, "Required static final int field: '?.STATUS_CODE' not defined", new Object[]{exceptionTypeElement.asType().toString()});
        })).getConstantValue();
    }

    private boolean isRxMicroExceptionClass(TypeElement exceptionTypeElement) {
        return DeniedPackages.isDeniedPackage((String)((PackageElement)exceptionTypeElement.getEnclosingElement()).getQualifiedName().toString());
    }

    private RestObjectModelClass getModelClass(EnvironmentContext environmentContext, TypeElement exceptionTypeElement) {
        ModuleElement currentModule = environmentContext.getCurrentModule();
        ModelFieldBuilderOptions options = new ModelFieldBuilderOptions().setWithFieldsFromParentClasses(false).setAccessViaReflectionMustBeDetected(false);
        return (RestObjectModelClass)this.modelFieldBuilder.build(ModelFieldType.REST_SERVER_RESPONSE, currentModule, Set.of(exceptionTypeElement), options).get(exceptionTypeElement);
    }

    private boolean isCustomParamsPresent(TypeElement exceptionTypeElement) {
        return !Elements.allModelFields((TypeElement)exceptionTypeElement, (boolean)false).isEmpty();
    }
}

