/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.DocumentStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.GenerationOutputOrganizer;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.AsciiDoctorDocumentStructure;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Resource;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.ResourceGroup;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.RestControllerBasicsDocumentStructure;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.RestControllerResourceDocumentStructure;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.documentation.DocumentationDefinition;
import io.rxmicro.documentation.asciidoctor.DocumentAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;

@Singleton
public final class GenerationOutputOrganizerImpl
implements GenerationOutputOrganizer {
    @Override
    public Set<? extends DocumentStructure> organize(EnvironmentContext environmentContext, ProjectMetaData projectMetaData, DocumentationDefinition documentationDefinition, List<ResourceGroup> resourceGroups, List<String> customSections) {
        ModuleElement currentModule = environmentContext.getCurrentModule();
        this.validateGenerationOutput(currentModule, documentationDefinition.output());
        HashSet<DocumentStructure> result = new HashSet<DocumentStructure>();
        Set<DocumentationDefinition.GenerationOutput> outputs = Set.of(documentationDefinition.output());
        if (outputs.contains(DocumentationDefinition.GenerationOutput.SINGLE_DOCUMENT)) {
            result.add(this.buildAsciiDoctorDocumentStructure(currentModule, projectMetaData, documentationDefinition, resourceGroups, customSections));
        }
        if (outputs.contains(DocumentationDefinition.GenerationOutput.BASICS_SECTION)) {
            resourceGroups.forEach(resourceGroup -> result.add(this.buildRestControllerBasicsDocumentStructure(currentModule, projectMetaData, documentationDefinition, (ResourceGroup)resourceGroup)));
        }
        if (outputs.contains(DocumentationDefinition.GenerationOutput.RESOURCES_SECTION)) {
            resourceGroups.forEach(resourceGroup -> resourceGroup.getResources().forEach(resource -> result.add(this.buildRestControllerResourceDocumentStructure(currentModule, projectMetaData, documentationDefinition, (ResourceGroup)resourceGroup, (Resource)resource))));
        }
        return result;
    }

    private void validateGenerationOutput(ModuleElement currentModule, DocumentationDefinition.GenerationOutput ... outputs) {
        if (outputs.length == 0) {
            throw new InterruptProcessingException((Element)currentModule, "Expected at least one GenerationOutput item", new Object[0]);
        }
        HashSet<DocumentationDefinition.GenerationOutput> outputSet = new HashSet<DocumentationDefinition.GenerationOutput>();
        for (DocumentationDefinition.GenerationOutput output : outputs) {
            if (outputSet.add(output)) continue;
            throw new InterruptProcessingException((Element)currentModule, "GenerationOutput duplicates not allowed", new Object[0]);
        }
    }

    private DocumentStructure buildAsciiDoctorDocumentStructure(ModuleElement currentModule, ProjectMetaData projectMetaData, DocumentationDefinition documentationDefinition, List<ResourceGroup> resourceGroups, List<String> customSections) {
        return new AsciiDoctorDocumentStructure(currentModule, projectMetaData, (DocumentAttributes)Annotations.getPresentOrDefaultAnnotation((AnnotatedConstruct)currentModule, DocumentAttributes.class), documentationDefinition, resourceGroups, customSections);
    }

    private DocumentStructure buildRestControllerBasicsDocumentStructure(ModuleElement currentModule, ProjectMetaData projectMetaData, DocumentationDefinition documentationDefinition, ResourceGroup resourceGroup) {
        return new RestControllerBasicsDocumentStructure(projectMetaData, documentationDefinition, currentModule, resourceGroup);
    }

    private DocumentStructure buildRestControllerResourceDocumentStructure(ModuleElement currentModule, ProjectMetaData projectMetaData, DocumentationDefinition documentationDefinition, ResourceGroup resourceGroup, Resource resource) {
        return new RestControllerResourceDocumentStructure(projectMetaData, documentationDefinition, currentModule, resourceGroup, resource);
    }
}

