/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.type.IterableModelClass;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.CharacteristicsReader;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.DocumentedModelFieldBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Characteristics;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.DocumentedModelField;
import io.rxmicro.annotation.processor.documentation.component.DescriptionReader;
import io.rxmicro.annotation.processor.documentation.model.ReadMoreModel;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.common.util.Formats;
import io.rxmicro.rest.model.HttpModelType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Singleton
public final class DocumentedModelFieldBuilderImpl
implements DocumentedModelFieldBuilder {
    @Inject
    private DescriptionReader descriptionReader;
    @Inject
    private CharacteristicsReader characteristicsReader;

    @Override
    public List<Map.Entry<String, List<DocumentedModelField>>> buildComplex(EnvironmentContext environmentContext, boolean withStandardDescriptions, String projectDirectory, RestObjectModelClass restObjectModelClass, HttpModelType httpModelType, boolean withReadMore) {
        if (httpModelType == HttpModelType.PATH) {
            return List.of(Map.entry("@null", restObjectModelClass.getAllDeclaredPathVariablesStream().map(entry -> this.buildDocumentedModelField(environmentContext, withStandardDescriptions, projectDirectory, (Map.Entry<RestModelField, ModelClass>)entry, null, withReadMore)).collect(Collectors.toList())));
        }
        if (httpModelType == HttpModelType.HEADER) {
            return List.of(Map.entry("@null", restObjectModelClass.getAllDeclaredHeadersStream(true).map(entry -> this.buildDocumentedModelField(environmentContext, withStandardDescriptions, projectDirectory, (Map.Entry<RestModelField, ModelClass>)entry, null, withReadMore)).collect(Collectors.toList())));
        }
        if (httpModelType == HttpModelType.PARAMETER) {
            ArrayList<Map.Entry<String, List<DocumentedModelField>>> list = new ArrayList<Map.Entry<String, List<DocumentedModelField>>>();
            this.extractModelRecursive(environmentContext, withStandardDescriptions, projectDirectory, "Body", list, restObjectModelClass, withReadMore);
            list.add(0, (Map.Entry)list.remove(list.size() - 1));
            return list;
        }
        throw new InternalErrorException("Unsupported documented HttpModelType: ?", new Object[]{httpModelType});
    }

    private void extractModelRecursive(EnvironmentContext environmentContext, boolean withStandardDescriptions, String projectDirectory, String name, List<Map.Entry<String, List<DocumentedModelField>>> entryList, RestObjectModelClass restObjectModelClass, boolean withReadMore) {
        ArrayList list = new ArrayList();
        restObjectModelClass.getAllDeclaredParametersStream().forEach(entry -> {
            if (((ModelClass)entry.getValue()).isObject()) {
                list.add(this.buildDocumentedModelField(environmentContext, withStandardDescriptions, projectDirectory, (Map.Entry<RestModelField, ModelClass>)entry, "object", withReadMore));
                this.extractModelRecursive(environmentContext, withStandardDescriptions, projectDirectory, Formats.format((String)"\"?\"", (Object[])new Object[]{((RestModelField)entry.getKey()).getModelName()}), entryList, (RestObjectModelClass)((ModelClass)entry.getValue()).asObject(), withReadMore);
            } else if (((ModelClass)entry.getValue()).isIterable()) {
                IterableModelClass iterableModelClass = ((ModelClass)entry.getValue()).asIterable();
                if (iterableModelClass.isObjectIterable()) {
                    list.add(this.buildDocumentedModelField(environmentContext, withStandardDescriptions, projectDirectory, (Map.Entry<RestModelField, ModelClass>)entry, "array", withReadMore));
                    this.extractModelRecursive(environmentContext, withStandardDescriptions, projectDirectory, Formats.format((String)"\"?\" Item", (Object[])new Object[]{((RestModelField)entry.getKey()).getModelName()}), entryList, (RestObjectModelClass)iterableModelClass.getElementModelClass().asObject(), withReadMore);
                } else {
                    list.add(this.buildDocumentedModelField(environmentContext, withStandardDescriptions, projectDirectory, (Map.Entry<RestModelField, ModelClass>)entry, "array", withReadMore));
                }
            } else {
                list.add(this.buildDocumentedModelField(environmentContext, withStandardDescriptions, projectDirectory, (Map.Entry<RestModelField, ModelClass>)entry, null, withReadMore));
            }
        });
        entryList.add(Map.entry(name, list));
    }

    private DocumentedModelField buildDocumentedModelField(EnvironmentContext environmentContext, boolean withStandardDescriptions, String projectDirectory, Map.Entry<RestModelField, ModelClass> entry, String jsonType, boolean withReadMore) {
        if (entry.getKey().isHttpHeader() && "Request-Id".equalsIgnoreCase(entry.getKey().getModelName())) {
            return DocumentedModelFieldBuilder.buildRequestIdHeaderDocumentedModelField(false);
        }
        Characteristics characteristics = this.characteristicsReader.read(environmentContext, entry);
        RestModelField field = entry.getKey();
        return new DocumentedModelField(field.getModelName(), jsonType != null ? jsonType : this.getJsonType(entry.getValue()), characteristics.getRestrictions(), this.descriptionReader.readDescription(field.getFieldElement(), projectDirectory).orElseGet(() -> withStandardDescriptions ? (String)characteristics.getStandardDescription().orElse(null) : null), withReadMore ? characteristics.getReadMores().stream().map(ReadMoreModel::new).collect(Collectors.toList()) : List.of());
    }

    private String getJsonType(ModelClass modelClass) {
        if (modelClass.isPrimitive()) {
            return modelClass.asPrimitive().getPrimitiveType().toJsonType();
        }
        if (modelClass.isEnum()) {
            return modelClass.asEnum().getPrimitiveType().toJsonType();
        }
        if (modelClass.isIterable()) {
            IterableModelClass iterableModelClass = modelClass.asIterable();
            if (iterableModelClass.isPrimitiveIterable() || iterableModelClass.isEnumIterable()) {
                return "array";
            }
            throw new InternalErrorException("Unsupported primitive model list: ?", new Object[]{iterableModelClass.getElementModelClass().getClass()});
        }
        throw new InternalErrorException("Unsupported primitive model class: ?", new Object[]{modelClass.getClass()});
    }
}

