/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.type.IterableModelClass;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.CharacteristicsReader;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.ArrayRestrictionReader;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.ObjectRestrictionReader;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.impl.restrictions.PrimitiveRestrictionReader;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Characteristics;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.meta.ReadMore;
import java.util.ArrayList;
import java.util.Map;

@Singleton
public final class CharacteristicsReaderImpl
implements CharacteristicsReader {
    private final PrimitiveRestrictionReader primitiveRestrictionReader = new PrimitiveRestrictionReader();
    private final ObjectRestrictionReader objectRestrictionReader = new ObjectRestrictionReader();
    private final ArrayRestrictionReader arrayRestrictionReader = new ArrayRestrictionReader();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Characteristics read(EnvironmentContext environmentContext, Map.Entry<RestModelField, ModelClass> entry) {
        ArrayList<String> restrictions = new ArrayList<String>();
        ArrayList<ReadMore> readMores = new ArrayList<ReadMore>();
        StringBuilder descriptionBuilder = new StringBuilder();
        if (entry.getValue().isObject()) {
            this.objectRestrictionReader.read(environmentContext, entry, restrictions, readMores);
            return new Characteristics(restrictions, readMores, descriptionBuilder.length() == 0 ? null : descriptionBuilder.toString());
        } else if (entry.getValue().isIterable()) {
            IterableModelClass iterableModelClass = entry.getValue().asIterable();
            if (iterableModelClass.isObjectIterable()) {
                this.objectRestrictionReader.read(environmentContext, entry, restrictions, readMores);
                this.arrayRestrictionReader.read(entry, restrictions, readMores);
                return new Characteristics(restrictions, readMores, descriptionBuilder.length() == 0 ? null : descriptionBuilder.toString());
            } else {
                if (!iterableModelClass.isPrimitiveIterable() && !iterableModelClass.isEnumIterable()) throw new InternalErrorException("?: Unsupported array model type: ?", new Object[]{this.getClass().getSimpleName(), iterableModelClass.getElementModelClass().getClass()});
                this.primitiveRestrictionReader.readPrimitive(environmentContext, entry, restrictions, readMores, descriptionBuilder);
                this.arrayRestrictionReader.read(entry, restrictions, readMores);
            }
            return new Characteristics(restrictions, readMores, descriptionBuilder.length() == 0 ? null : descriptionBuilder.toString());
        } else {
            if (!entry.getValue().isPrimitive() && !entry.getValue().isEnum()) throw new InternalErrorException("?: Unsupported model type: ?", new Object[]{this.getClass().getSimpleName(), entry.getValue()});
            this.primitiveRestrictionReader.readPrimitive(environmentContext, entry, restrictions, readMores, descriptionBuilder);
        }
        return new Characteristics(restrictions, readMores, descriptionBuilder.length() == 0 ? null : descriptionBuilder.toString());
    }
}

