/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor;

import com.google.inject.Inject;
import com.google.inject.Module;
import io.rxmicro.annotation.processor.common.CommonDependenciesModule;
import io.rxmicro.annotation.processor.common.model.DocumentStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.Injects;
import io.rxmicro.annotation.processor.config.DocumentationType;
import io.rxmicro.annotation.processor.documentation.DocumentationDependenciesModule;
import io.rxmicro.annotation.processor.documentation.asciidoctor.AsciiDoctorDocumentationDependenciesModule;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.GenerationOutputOrganizer;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.RequestBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.component.ResponsesBuilder;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.Resource;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.ResourceGroup;
import io.rxmicro.annotation.processor.documentation.component.CustomSectionsReader;
import io.rxmicro.annotation.processor.documentation.component.DescriptionReader;
import io.rxmicro.annotation.processor.documentation.component.IncludeReferenceSyntaxProvider;
import io.rxmicro.annotation.processor.documentation.component.ProjectMetaDataReader;
import io.rxmicro.annotation.processor.documentation.component.TitleReader;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.annotation.processor.rest.RestCommonDependenciesModule;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.server.RestServerDependenciesModule;
import io.rxmicro.annotation.processor.rest.server.component.AbstractDocumentationModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethod;
import io.rxmicro.documentation.DocumentationDefinition;
import io.rxmicro.documentation.ResourceDefinition;
import io.rxmicro.documentation.ResourceGroupDefinition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;

public final class AsciiDoctorModuleClassStructuresBuilder
extends AbstractDocumentationModuleClassStructuresBuilder {
    @Inject
    private ProjectMetaDataReader projectMetaDataReader;
    @Inject
    private TitleReader titleReader;
    @Inject
    private DescriptionReader descriptionReader;
    @Inject
    private CustomSectionsReader customSectionsReader;
    @Inject
    private IncludeReferenceSyntaxProvider includeReferenceSyntaxProvider;
    @Inject
    private RequestBuilder requestBuilder;
    @Inject
    private ResponsesBuilder responsesBuilder;
    @Inject
    private GenerationOutputOrganizer generationOutputOrganizer;

    public AsciiDoctorModuleClassStructuresBuilder() {
        Injects.injectDependencies((Object)((Object)this), (Module[])new Module[]{new CommonDependenciesModule(), new DocumentationDependenciesModule(), new AsciiDoctorDocumentationDependenciesModule(), new RestCommonDependenciesModule(), new RestServerDependenciesModule()});
    }

    public Set<? extends DocumentStructure> build(EnvironmentContext environmentContext, RestControllerClassStructureStorage restControllerClassStructureStorage, Set<RestControllerClassStructure> restControllerClassStructures) {
        ModuleElement currentModule = environmentContext.getCurrentModule();
        ProjectMetaData projectMetaData = this.projectMetaDataReader.read(currentModule);
        DocumentationDefinition documentationDefinition = (DocumentationDefinition)Annotations.getPresentOrDefaultAnnotation((AnnotatedConstruct)currentModule, DocumentationDefinition.class);
        List<ResourceGroup> resourceGroups = this.buildResourceGroups(environmentContext, projectMetaData, documentationDefinition, restControllerClassStructureStorage, restControllerClassStructures);
        List customSections = this.customSectionsReader.read((Element)currentModule, documentationDefinition.introduction(), projectMetaData, this.includeReferenceSyntaxProvider);
        return this.generationOutputOrganizer.organize(environmentContext, projectMetaData, documentationDefinition, resourceGroups, customSections);
    }

    public DocumentationType getDocumentationType() {
        return DocumentationType.ASCII_DOCTOR;
    }

    private List<ResourceGroup> buildResourceGroups(EnvironmentContext environmentContext, ProjectMetaData projectMetaData, DocumentationDefinition documentationDefinition, RestControllerClassStructureStorage restControllerClassStructureStorage, Set<RestControllerClassStructure> restControllerClassStructures) {
        return restControllerClassStructures.stream().map(cl -> this.buildResourceGroup(environmentContext, projectMetaData, documentationDefinition, restControllerClassStructureStorage, (RestControllerClassStructure)cl)).collect(Collectors.toList());
    }

    private ResourceGroup buildResourceGroup(EnvironmentContext environmentContext, ProjectMetaData projectMetaData, DocumentationDefinition documentationDefinition, RestControllerClassStructureStorage restControllerClassStructureStorage, RestControllerClassStructure classStructure) {
        String name = this.titleReader.readTitleOrDefault((Element)classStructure.getOwnerClass());
        String description = this.descriptionReader.readDescription((Element)classStructure.getOwnerClass(), projectMetaData.getProjectDirectory()).orElse(null);
        List<Resource> resources = this.buildResources(environmentContext, projectMetaData, documentationDefinition, restControllerClassStructureStorage, classStructure);
        ResourceGroupDefinition resourceGroupDefinition = classStructure.getOwnerClass().getAnnotation(ResourceGroupDefinition.class);
        List customSections = this.customSectionsReader.read((Element)(resourceGroupDefinition != null ? classStructure.getOwnerClass() : environmentContext.getCurrentModule()), resourceGroupDefinition != null ? resourceGroupDefinition : documentationDefinition.resourceGroup(), projectMetaData, this.includeReferenceSyntaxProvider);
        return new ResourceGroup(resourceGroupDefinition != null ? resourceGroupDefinition : documentationDefinition.resourceGroup(), name, description, classStructure, resources, customSections);
    }

    private List<Resource> buildResources(EnvironmentContext environmentContext, ProjectMetaData projectMetaData, DocumentationDefinition documentationDefinition, RestControllerClassStructureStorage restControllerClassStructureStorage, RestControllerClassStructure classStructure) {
        return classStructure.getMethods().stream().flatMap(m -> m.getHttpMethodMappings().stream().map(h -> Map.entry(h, m))).map(e -> this.buildResource(environmentContext, projectMetaData, documentationDefinition, classStructure, restControllerClassStructureStorage, (HttpMethodMapping)e.getKey(), (RestControllerMethod)e.getValue())).collect(Collectors.toList());
    }

    private Resource buildResource(EnvironmentContext environmentContext, ProjectMetaData projectMetaData, DocumentationDefinition documentationDefinition, RestControllerClassStructure classStructure, RestControllerClassStructureStorage storage, HttpMethodMapping httpMethodMapping, RestControllerMethod method) {
        ResourceDefinition resourceDefinition = Optional.ofNullable(method.getMethod().getAnnotation(ResourceDefinition.class)).orElseGet(() -> Optional.ofNullable(classStructure.getOwnerClass().getAnnotation(ResourceDefinition.class)).orElseGet(() -> ((DocumentationDefinition)documentationDefinition).resource()));
        Resource.Builder builder = new Resource.Builder().setRestControllerMethod(method).setHttpMethodMapping(httpMethodMapping).setName(this.titleReader.readTitleOrDefault((Element)method.getMethod())).setRequest(this.requestBuilder.buildRequest(environmentContext, projectMetaData, resourceDefinition, classStructure, httpMethodMapping, method, storage)).addResponse(this.responsesBuilder.buildSuccessResponse(resourceDefinition, projectMetaData, environmentContext, method, storage));
        this.responsesBuilder.buildErrorResponses(environmentContext, projectMetaData, documentationDefinition, resourceDefinition, classStructure, method).forEach(builder::addResponse);
        this.descriptionReader.readDescription((Element)method.getMethod(), projectMetaData.getProjectDirectory()).ifPresent(builder::setDescription);
        return builder.build();
    }
}

