/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.model;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.data.Pageable;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class Variable {
    private final VariableElement element;
    private final String name;
    private final String getter;
    private final int repeatCount;
    private final boolean limit;
    private final boolean skip;

    private Variable(VariableElement element, String name, String getter, int repeatCount) {
        this.element = (VariableElement)Requires.require((Object)element);
        this.name = (String)Requires.require((Object)name);
        this.getter = (String)Requires.require((Object)getter);
        this.repeatCount = repeatCount;
        if (Pageable.class.getName().equals(element.asType().toString())) {
            this.limit = getter.contains("getLimit");
            this.skip = getter.contains("getOffset");
        } else {
            this.limit = Pageable.LIMIT_NAMES.contains(element.getSimpleName().toString()) && element.asType().getKind() == TypeKind.INT;
            this.skip = Pageable.OFFSET_NAMES.contains(element.getSimpleName().toString()) && element.asType().getKind() == TypeKind.INT;
        }
    }

    public String getGetter() {
        return this.getter;
    }

    public String getName() {
        return this.name;
    }

    public TypeMirror getType() {
        return this.element.asType();
    }

    public Element getElement() {
        return this.element;
    }

    public boolean is(Class<?> type) {
        return type.getName().equals(this.getType().toString());
    }

    public boolean is(String fullClassName) {
        return fullClassName.equals(this.getType().toString());
    }

    public boolean isRepeated() {
        return this.repeatCount > 1;
    }

    public boolean isLimit() {
        return this.limit;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Variable variable = (Variable)other;
        return this.repeatCount == variable.repeatCount && this.element.equals(variable.element) && this.name.equals(variable.name) && this.getter.equals(variable.getter);
    }

    public int hashCode() {
        return Objects.hash(this.element, this.name, this.getter, this.repeatCount);
    }

    public String toString() {
        return Formats.format((String)"? ?", (Object[])new Object[]{this.getType(), this.name});
    }

    public static final class Builder {
        private VariableElement variableElement;
        private String name;
        private String getter;
        private int repeatCount = 1;

        public Builder setVariableElement(VariableElement variableElement) {
            this.variableElement = (VariableElement)Requires.require((Object)variableElement);
            this.setName(variableElement.getSimpleName().toString());
            this.setGetter(this.name);
            return this;
        }

        public Builder setName(String name) {
            this.name = (String)Requires.require((Object)name);
            this.setGetter(name);
            return this;
        }

        public Builder setGetter(String getter) {
            this.getter = (String)Requires.require((Object)getter);
            return this;
        }

        public Builder setRepeatCount(int repeatCount) {
            this.repeatCount = repeatCount;
            return this;
        }

        public Variable build() {
            return new Variable(this.variableElement, this.name, this.getter, this.repeatCount);
        }
    }
}

