/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.model;

import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.VariableElement;

public abstract class DataRepositoryMethod {
    private final String operationName;
    private final DataRepositoryMethodSignature methodSignature;
    private final MethodBody body;

    public DataRepositoryMethod(String operationName, DataRepositoryMethodSignature methodSignature, MethodBody body) {
        this.operationName = operationName;
        this.methodSignature = (DataRepositoryMethodSignature)Requires.require((Object)methodSignature);
        this.body = (MethodBody)Requires.require((Object)body);
    }

    public String getOperationName() {
        return this.operationName;
    }

    public DataRepositoryMethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    public String getReturnType() {
        return this.methodSignature.getMethodResult().getHumanReadableReturnType();
    }

    public String getName() {
        return this.methodSignature.getMethod().getSimpleName().toString();
    }

    public String getParams() {
        return this.methodSignature.getParams().stream().map(e -> Formats.format((String)"final ? ?", (Object[])new Object[]{e.getSimpleType(), e.getName()})).collect(Collectors.joining(", "));
    }

    public List<? extends VariableElement> getParameters() {
        return this.methodSignature.getMethod().getParameters();
    }

    public List<String> getBodyLines() {
        return this.body.getLines();
    }
}

