/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.model;

import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.common.util.ExCollections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class DataMethodParams {
    private final Map<String, List<Variable>> params;
    private final List<Variable> otherParams;

    public DataMethodParams(Map<String, List<Variable>> params, List<Variable> otherParams) {
        this.params = ExCollections.unmodifiableMap(params);
        this.otherParams = ExCollections.unmodifiableList(otherParams);
    }

    public List<Variable> getParamsOfGroup(String groupName) {
        return Optional.ofNullable(this.params.get(groupName)).orElse(List.of());
    }

    public Optional<Variable> getSingleParamOfGroup(String groupName) {
        List<Variable> params = this.getParamsOfGroup(groupName);
        if (params.isEmpty()) {
            return Optional.empty();
        }
        if (params.size() > 1) {
            Variable last = params.get(params.size() - 1);
            throw new InterruptProcessingException(last.getElement(), "Detected redundant '?' parameter! Remove it!", new Object[]{last.getName()});
        }
        return Optional.of(params.get(0));
    }

    public List<Variable> getOtherParams() {
        return this.otherParams;
    }
}

