/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.data.component.DataMethodParamsResolver;
import io.rxmicro.annotation.processor.data.model.DataMethodParams;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.common.util.Formats;
import io.rxmicro.data.Pageable;
import io.rxmicro.data.RepeatParameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class DataMethodParamsResolverImpl
implements DataMethodParamsResolver {
    @Override
    public DataMethodParams resolve(ExecutableElement method, Map<String, Predicate<VariableElement>> groupRules, boolean allowShareVariableForGroups) {
        LinkedHashMap<String, List<Variable>> params = new LinkedHashMap<String, List<Variable>>();
        ArrayList<Variable> otherParams = new ArrayList<Variable>();
        for (VariableElement variableElement : method.getParameters()) {
            HashSet<String> rules = new HashSet<String>();
            for (Map.Entry<String, Predicate<VariableElement>> entry : groupRules.entrySet()) {
                if (!entry.getValue().test(variableElement)) continue;
                String rule = entry.getKey();
                List variables = params.computeIfAbsent(rule, v -> new ArrayList());
                this.addVariables(variables, variableElement);
                rules.add(rule);
            }
            if (rules.size() > 1) {
                if (allowShareVariableForGroups) continue;
                throw new InterruptProcessingException((Element)variableElement, "Detected shared parameter! Contact with the RxMicro support team!", new Object[0]);
            }
            if (!rules.isEmpty()) continue;
            this.addVariables(otherParams, variableElement);
        }
        return new DataMethodParams(params, otherParams);
    }

    private void addVariables(List<Variable> variables, VariableElement parameter) {
        int repeatCount = Optional.ofNullable(parameter.getAnnotation(RepeatParameter.class)).map(RepeatParameter::value).orElse(1);
        for (int i = 0; i < repeatCount; ++i) {
            this.addVariable(variables, parameter, repeatCount);
        }
    }

    private void addVariable(List<Variable> variables, VariableElement parameter, int repeatCount) {
        Variable.Builder builder = new Variable.Builder().setRepeatCount(repeatCount).setVariableElement(parameter);
        if (Elements.asEnumElement((TypeMirror)parameter.asType()).isPresent()) {
            if (Elements.isNotStandardEnum((TypeMirror)parameter.asType())) {
                variables.add(builder.setGetter(Formats.format((String)"?.sql()", (Object[])new Object[]{parameter.getSimpleName()})).build());
            } else {
                variables.add(builder.build());
            }
        } else if (Pageable.class.getName().equals(parameter.asType().toString())) {
            String name = parameter.getSimpleName().toString();
            variables.add(builder.setName(name).setGetter(Formats.format((String)"?.getLimit()", (Object[])new Object[]{name})).build());
            variables.add(builder.setName(name).setGetter(Formats.format((String)"?.getOffset()", (Object[])new Object[]{name})).build());
        } else {
            variables.add(builder.build());
        }
    }
}

