/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.impl.AbstractModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingBecauseAFewErrorsFoundException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.LoggerMessages;
import io.rxmicro.annotation.processor.data.component.DataClassStructureBuilder;
import io.rxmicro.annotation.processor.data.component.DataGenerationContextBuilder;
import io.rxmicro.annotation.processor.data.component.DataRepositoryConfigAutoCustomizerBuilder;
import io.rxmicro.annotation.processor.data.component.DataRepositoryInterfaceSignatureBuilder;
import io.rxmicro.annotation.processor.data.component.EntityConverterBuilder;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataModelField;
import io.rxmicro.annotation.processor.data.model.DataObjectModelClass;
import io.rxmicro.annotation.processor.data.model.DataRepositoryClassStructure;
import io.rxmicro.annotation.processor.data.model.DataRepositoryInterfaceSignature;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethod;
import io.rxmicro.common.util.Formats;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public abstract class AbstractDataModuleClassStructuresBuilder<DMF extends DataModelField, DMC extends DataObjectModelClass<DMF>>
extends AbstractModuleClassStructuresBuilder {
    @Inject
    private DataRepositoryInterfaceSignatureBuilder dataRepositoryInterfaceSignatureBuilder;
    @Inject
    private DataGenerationContextBuilder<DMF, DMC> dataGenerationContextBuilder;
    @Inject
    private DataClassStructureBuilder<DMF, DMC> dataClassStructureBuilder;
    @Inject
    private EntityConverterBuilder<DMF, DMC> entityConverterBuilder;
    @Inject
    private DataRepositoryConfigAutoCustomizerBuilder dataRepositoryConfigAutoCustomizerBuilder;

    public final Set<? extends ClassStructure> buildClassStructures(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            Set<DataRepositoryInterfaceSignature> signatures = this.dataRepositoryInterfaceSignatureBuilder.build(environmentContext, annotations, roundEnv);
            DataGenerationContext<DMF, DMC> dataGenerationContext = this.dataGenerationContextBuilder.build(environmentContext.getCurrentModule(), new ArrayList<DataRepositoryInterfaceSignature>(signatures));
            Set<DataRepositoryClassStructure> dataRepositoryClassStructures = signatures.stream().map(signature -> this.dataClassStructureBuilder.build(environmentContext, (DataRepositoryInterfaceSignature)((Object)signature), dataGenerationContext)).collect(Collectors.toSet());
            this.logFoundDataRepositories(dataRepositoryClassStructures);
            HashSet<DataRepositoryClassStructure> result = new HashSet<DataRepositoryClassStructure>(dataRepositoryClassStructures);
            Set<ClassStructure> entityConverters = this.entityConverterBuilder.build(dataGenerationContext);
            this.logClassStructureStorageItem("entity converter(s)", entityConverters);
            result.addAll(entityConverters);
            this.dataRepositoryConfigAutoCustomizerBuilder.build(dataRepositoryClassStructures).ifPresent(e -> {
                result.add((DataRepositoryClassStructure)((Object)e));
                this.logClassStructureStorageItem("data repository config auto customizer", Set.of(e));
            });
            return result;
        }
        catch (InterruptProcessingException ex) {
            this.error(ex);
            return Set.of();
        }
        catch (InterruptProcessingBecauseAFewErrorsFoundException ignore) {
            return Set.of();
        }
    }

    private void logFoundDataRepositories(Set<DataRepositoryClassStructure> dataRepositoryClassStructures) {
        if (this.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Found the following data repositories:\n");
            for (DataRepositoryClassStructure classStructure : dataRepositoryClassStructures) {
                stringBuilder.append(Formats.format((String)"??:\n", (Object[])new Object[]{"  ", classStructure.getFullInterfaceName()}));
                for (DataRepositoryMethod dataRepositoryMethod : classStructure.getMethods()) {
                    stringBuilder.append(Formats.format((String)"??'?' -> ?;\n", (Object[])new Object[]{"  ", "  ", dataRepositoryMethod.getOperationName(), LoggerMessages.getLoggableMethodName((ExecutableElement)dataRepositoryMethod.getMethodSignature().getMethod())}));
                }
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            this.info(stringBuilder.toString(), new Supplier[0]);
        }
    }
}

