/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.model;

import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.common.InvalidStateException;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ModuleElement;

public final class SQLMethodDescriptor<DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>> {
    private final ModuleElement currentModule;
    private final List<Variable> params;
    private final MethodResult result;
    private final DMC entityParam;
    private final DMC entityResult;

    private SQLMethodDescriptor(ModuleElement currentModule, List<Variable> params, MethodResult result, DMC entityParam, DMC entityResult) {
        this.currentModule = currentModule;
        this.params = params;
        this.result = result;
        this.entityParam = entityParam;
        this.entityResult = entityResult;
    }

    public ModuleElement getCurrentModule() {
        return this.currentModule;
    }

    public List<Variable> getParams() {
        return this.params;
    }

    public MethodResult getResult() {
        return this.result;
    }

    public Optional<DMC> getEntityParam() {
        return Optional.ofNullable(this.entityParam);
    }

    public Optional<DMC> getEntityResult() {
        return Optional.ofNullable(this.entityResult);
    }

    public static final class Builder<DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>> {
        private final ModuleElement currentModule;
        private final List<Variable> params;
        private final MethodResult result;
        private DMC entityParam;
        private DMC entityResult;

        public Builder(ModuleElement currentModule, List<Variable> params, MethodResult result) {
            this.currentModule = (ModuleElement)Requires.require((Object)currentModule);
            this.params = (List)Requires.require(params);
            this.result = (MethodResult)Requires.require((Object)result);
        }

        public boolean isEntityParamSet() {
            return this.entityParam != null;
        }

        public void setEntityParam(DMC entityParam) {
            if (this.entityParam != null) {
                throw new InvalidStateException("entityParam already set");
            }
            this.entityParam = (SQLDataObjectModelClass)((Object)Requires.require(entityParam));
        }

        public void setEntityResult(DMC entityResult) {
            if (this.entityResult != null) {
                throw new InvalidStateException("entityResult already set");
            }
            this.entityResult = (SQLDataObjectModelClass)((Object)Requires.require(entityResult));
        }

        public SQLMethodDescriptor<DMF, DMC> build() {
            return new SQLMethodDescriptor(this.currentModule, this.params, this.result, this.entityParam, this.entityResult);
        }
    }
}

