/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.model;

import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.model.DataModelField;
import io.rxmicro.annotation.processor.data.sql.model.VariableContext;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Strings;
import io.rxmicro.data.Column;
import io.rxmicro.data.sql.NotInsertable;
import io.rxmicro.data.sql.PrimaryKey;
import io.rxmicro.data.sql.SequenceGenerator;
import java.util.Optional;

public class SQLDataModelField
extends DataModelField {
    private final int length;
    private final boolean nullable;
    private String insertValue;
    private boolean initInsertValue;
    private Boolean lengthPresent;

    public SQLDataModelField(AnnotatedModelElement annotatedModelElement, String modelName, int length, boolean nullable) {
        super(annotatedModelElement, modelName);
        this.length = length;
        this.nullable = nullable;
        this.initInsertValue = false;
    }

    public String getColumnName() {
        return this.getModelName();
    }

    public Optional<String> getInsertValue(VariableContext variableContext) {
        if (!this.initInsertValue) {
            this.initInsertValue = true;
            PrimaryKey primaryKey = (PrimaryKey)this.getAnnotation(PrimaryKey.class);
            if (primaryKey != null) {
                this.validateNotInsertable();
                if (primaryKey.autoGenerated()) {
                    SequenceGenerator sequenceGenerator = (SequenceGenerator)this.getAnnotation(SequenceGenerator.class);
                    if (sequenceGenerator != null) {
                        this.validateSequenceGenerator(sequenceGenerator);
                        String sequenceName = this.getSequenceName(variableContext, sequenceGenerator);
                        try {
                            this.insertValue = variableContext.getNextSequenceValue(sequenceName);
                        }
                        catch (UnsupportedOperationException ignore) {
                            throw new InterruptProcessingException(this.getElementAnnotatedBy(SequenceGenerator.class), "Current database does not support sequences", new Object[0]);
                        }
                    } else {
                        this.insertValue = null;
                    }
                } else {
                    this.insertValue = Formats.FORMAT_PLACEHOLDER_TOKEN;
                }
            } else {
                this.insertValue = Formats.FORMAT_PLACEHOLDER_TOKEN;
            }
        }
        return Optional.ofNullable(this.insertValue);
    }

    private String getSequenceName(VariableContext variableContext, SequenceGenerator sequenceGenerator) {
        String schema = Optional.of(sequenceGenerator.schema()).filter(v -> !v.isEmpty()).or(() -> variableContext.getCurrentTableName().getSchema()).orElse("");
        String table = variableContext.getCurrentTableName().getSimpleName();
        String sequenceName = sequenceGenerator.value().replace("${schema}", schema).replace("${table}", table).trim();
        return Strings.startsWith((String)sequenceName, (char)'.') ? sequenceName.substring(1) : sequenceName;
    }

    private void validateSequenceGenerator(SequenceGenerator sequenceGenerator) {
        if (!sequenceGenerator.schema().isEmpty() && !sequenceGenerator.value().contains("${schema}")) {
            throw new InterruptProcessingException(this.getFieldElement(), "If schema is provided for sequence generator, sequence name must contain required ${schema} variable. Add the required variable or remove the sequence schema", new Object[0]);
        }
    }

    private void validateNotInsertable() {
        if (this.getAnnotation(NotInsertable.class) != null) {
            throw new InterruptProcessingException(this.getFieldElement(), "'@?' couldn't be applied to primary key. Remove redundant annotation", new Object[]{NotInsertable.class.getName()});
        }
    }

    public boolean isInsertValuePlaceholder() {
        return Formats.FORMAT_PLACEHOLDER_TOKEN.equals(this.insertValue);
    }

    public boolean isLengthPresent() {
        if (this.lengthPresent == null) {
            if (String.class.getName().equals(this.getFieldClass().toString())) {
                if (this.length == -1) {
                    throw new InterruptProcessingException(this.getFieldElement(), "Missing a required column length value for '?' column type. If it is necessary to set unlimited value use '?.UNLIMITED_LENGTH' constant!", new Object[]{String.class.getName(), Column.class.getName()});
                }
                this.lengthPresent = this.length > 0;
            } else {
                if (this.length != -1) {
                    throw new InterruptProcessingException(this.getFieldElement(), "Column length supported for '?' column type only. Remove redundant column declaration!", new Object[]{String.class.getName()});
                }
                this.lengthPresent = false;
            }
        }
        return this.lengthPresent;
    }

    public int getLength() {
        return this.length;
    }

    public String getTrimMethodName() {
        return this.nullable ? "trimNullable" : "trimNotNull";
    }
}

