/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl.builder.select;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.component.SQLFieldsOrderExtractor;
import io.rxmicro.annotation.processor.data.sql.component.SQLVariableValueResolver;
import io.rxmicro.annotation.processor.data.sql.component.impl.SQLFieldsOrderValidator;
import io.rxmicro.annotation.processor.data.sql.component.impl.builder.AbstractSQLBuilder;
import io.rxmicro.annotation.processor.data.sql.model.BindParameter;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.annotation.processor.data.sql.model.SQLVariableValue;
import io.rxmicro.annotation.processor.data.sql.model.SelectedColumn;
import io.rxmicro.annotation.processor.data.sql.model.SelectedColumnFilter;
import io.rxmicro.annotation.processor.data.sql.model.VariableContext;
import io.rxmicro.annotation.processor.data.sql.model.VariableValuesMap;
import io.rxmicro.annotation.processor.data.sql.model.inject.SupportedSelectResultsVariables;
import io.rxmicro.annotation.processor.data.sql.util.SQLs;
import io.rxmicro.common.util.Formats;
import io.rxmicro.data.sql.operation.Select;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class PredefinedSelectSQLBuilder<DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
extends AbstractSQLBuilder {
    @Inject
    private SQLVariableValueResolver<Select, DMF, DMC> selectSQLVariableValueResolver;
    @Inject
    private SQLFieldsOrderValidator sqlFieldsOrderValidator;
    @Inject
    private SQLFieldsOrderExtractor sqlFieldsOrderExtractor;
    @Inject
    private VariableContext variableContext;
    @Inject
    @SupportedSelectResultsVariables
    private Set<String> supportedVariables;

    @Override
    protected boolean shouldAsteriskBeIgnored(int index, List<String> sqlTokens) {
        return index != 1;
    }

    public SQLStatement buildPredefinedSQL(ClassHeader.Builder classHeaderBuilder, ParsedSQL<Select> parsedSQL, ExecutableElement method, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor) {
        ArrayList<String> sqlTokens = new ArrayList<String>(parsedSQL.getSqlTokens());
        String originalSQL = SQLs.joinTokensToSQL(sqlTokens);
        this.validateSelectStatement(method, sqlTokens);
        boolean shouldExpandAsterisk = parsedSQL.getAnnotation().expandAsterisk() && sqlMethodDescriptor.getEntityResult().isPresent();
        Set<String> vars = this.extractVariables(method, sqlTokens, shouldExpandAsterisk ? List.of("*") : List.of());
        VariableValuesMap variableValuesMap = this.selectSQLVariableValueResolver.resolveVariableValues(this.variableContext, parsedSQL, method, sqlMethodDescriptor);
        this.validateSupportedVars(Select.class, method, vars, this.supportedVariables, variableValuesMap.keySet(), "*");
        this.setVariableValues(method, sqlTokens, vars, variableValuesMap);
        this.validatePlaceholderCount(method, sqlTokens, sqlMethodDescriptor.getParams());
        return this.build(classHeaderBuilder, method, sqlTokens, sqlMethodDescriptor.getParams(), variableValuesMap, originalSQL, sqlMethodDescriptor);
    }

    private void validateSelectStatement(ExecutableElement method, List<String> sqlTokens) {
        if (sqlTokens.isEmpty() || !"SELECT".equalsIgnoreCase(sqlTokens.get(0))) {
            throw new InterruptProcessingException((Element)method, "Select SQL query must start with '?' keyword", new Object[]{"SELECT"});
        }
    }

    private SQLStatement build(ClassHeader.Builder classHeaderBuilder, ExecutableElement method, List<String> sqlTokens, List<Variable> methodParams, VariableValuesMap variableValuesMap, String originalSQL, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor) {
        ArrayList<String> formatParams = new ArrayList<String>();
        ArrayList<BindParameter> bindParams = new ArrayList<BindParameter>();
        this.splitParams(method, classHeaderBuilder, sqlTokens, methodParams, formatParams, bindParams);
        SQLStatement.Builder builder = new SQLStatement.Builder().setOriginalSql(originalSQL).setBindParams(bindParams);
        String sql = SQLs.joinTokensToSQL(sqlTokens);
        if (formatParams.isEmpty()) {
            builder.setSqlExpression(Formats.format((String)"\"?\"", (Object[])new Object[]{sql}));
        } else {
            classHeaderBuilder.addStaticImport(Formats.class, "format");
            builder.setSqlExpression(Formats.format((String)"format(\"?\", ?)", (Object[])new Object[]{sql, String.join((CharSequence)", ", formatParams)}));
        }
        sqlMethodDescriptor.getEntityResult().ifPresent(modelClass -> {
            List<SelectedColumn> selectedColumns = this.sqlFieldsOrderExtractor.getSelectedColumns(sqlTokens, this.getSelectedColumnFilter());
            List<String> defaultColumns = this.getDefaultColumns(variableValuesMap);
            this.sqlFieldsOrderValidator.validateSelectedColumn(method, (SQLDataObjectModelClass<?>)((Object)modelClass), defaultColumns, selectedColumns);
            builder.setResultColumns(selectedColumns.stream().flatMap(c -> c.getCaption().stream()).collect(Collectors.toList())).setDefaultColumnOrder(this.isDefaultColumnOrder(selectedColumns, defaultColumns));
        });
        return builder.build();
    }

    protected SelectedColumnFilter getSelectedColumnFilter() {
        return new SelectedColumnFilter.Builder().setStartIndex(1).setBreakTokens(Set.of("FROM")).setIgnoredTokens(Set.of("ALL", "DISTINCT")).build();
    }

    private List<String> getDefaultColumns(VariableValuesMap variableValuesMap) {
        return Optional.ofNullable(variableValuesMap.getSqlVariableValue("${all-columns}")).map(SQLVariableValue::getColumns).orElse(List.of());
    }

    private boolean isDefaultColumnOrder(List<SelectedColumn> selectedColumns, List<String> defaultColumns) {
        return defaultColumns.equals(selectedColumns.stream().flatMap(c -> c.getCaption().stream()).collect(Collectors.toList()));
    }
}

