/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl.builder;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.data.sql.component.SQLBuilder;
import io.rxmicro.annotation.processor.data.sql.component.SQLVariableValueResolver;
import io.rxmicro.annotation.processor.data.sql.component.impl.builder.AbstractSQLBuilder;
import io.rxmicro.annotation.processor.data.sql.model.BindParameter;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.annotation.processor.data.sql.model.VariableContext;
import io.rxmicro.annotation.processor.data.sql.model.VariableValuesMap;
import io.rxmicro.annotation.processor.data.sql.util.SQLs;
import io.rxmicro.common.util.Formats;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;

public abstract class AbstractModificationSQLBuilder<A extends Annotation, DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
extends AbstractSQLBuilder
implements SQLBuilder<A, DMF, DMC> {
    @Inject
    private SQLVariableValueResolver<A, DMF, DMC> sqlVariableValueResolver;
    @Inject
    private VariableContext variableContext;
    private Set<String> supportedVariables;

    @Override
    public final SQLStatement build(ClassHeader.Builder classHeaderBuilder, ParsedSQL<A> parsedSQL, ExecutableElement method, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor) {
        ArrayList<String> sqlTokens = new ArrayList<String>(parsedSQL.getSqlTokens());
        String originalSQL = SQLs.joinTokensToSQL(sqlTokens);
        this.validateStatement(method, sqlTokens);
        Set<String> vars = this.extractVariables(method, sqlTokens, List.of("*"));
        VariableValuesMap variableValuesMap = this.sqlVariableValueResolver.resolveVariableValues(this.variableContext, parsedSQL, method, sqlMethodDescriptor);
        this.validateSupportedVars(parsedSQL.getAnnotation().annotationType(), method, vars, this.getSupportedVariables(), variableValuesMap.keySet(), "*");
        this.setVariableValues(method, sqlTokens, vars, variableValuesMap);
        SQLStatement.Builder builder = new SQLStatement.Builder().setOriginalSql(originalSQL);
        this.setResultColumns(method, builder, sqlTokens, sqlMethodDescriptor);
        if (sqlMethodDescriptor.getEntityParam().isPresent()) {
            this.replaceAllPlaceholders(sqlTokens);
            return builder.setSqlExpression(Formats.format((String)"\"?\"", (Object[])new Object[]{SQLs.joinTokensToSQL(sqlTokens)})).build();
        }
        return this.buildParametrized(method, classHeaderBuilder, sqlMethodDescriptor, builder, sqlTokens);
    }

    protected abstract void setResultColumns(ExecutableElement var1, SQLStatement.Builder var2, List<String> var3, SQLMethodDescriptor<DMF, DMC> var4);

    public final Set<String> getSupportedVariables() {
        if (this.supportedVariables == null) {
            this.supportedVariables = Stream.concat(this.getSupportedParamsVariables().stream(), this.getSupportedResultsVariables().stream()).collect(Collectors.toSet());
        }
        return this.supportedVariables;
    }

    protected abstract Set<String> getSupportedParamsVariables();

    protected abstract Set<String> getSupportedResultsVariables();

    protected abstract void validateStatement(ExecutableElement var1, List<String> var2);

    private SQLStatement buildParametrized(ExecutableElement method, ClassHeader.Builder classHeaderBuilder, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor, SQLStatement.Builder builder, List<String> sqlTokens) {
        ArrayList<String> formatParams = new ArrayList<String>();
        ArrayList<BindParameter> bindParams = new ArrayList<BindParameter>();
        this.splitParams(method, classHeaderBuilder, sqlTokens, sqlMethodDescriptor.getParams(), formatParams, bindParams);
        String sql = SQLs.joinTokensToSQL(sqlTokens);
        if (formatParams.isEmpty()) {
            builder.setSqlExpression(Formats.format((String)"\"?\"", (Object[])new Object[]{sql}));
        } else {
            classHeaderBuilder.addStaticImport(Formats.class, "format");
            builder.setSqlExpression(Formats.format((String)"format(\"?\", ?)", (Object[])new Object[]{sql, String.join((CharSequence)", ", formatParams)}));
        }
        return builder.setBindParams(bindParams).build();
    }
}

