/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.postgresql.component.impl.method;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataMethodParams;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl.AbstractSQLModificationOperationReturningResultDataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.sql.r2dbc.postgresql.model.PostgreSQLDataObjectModelClass;
import io.rxmicro.data.sql.operation.Insert;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

@Singleton
public final class PostgreSQLInsertWithReturningSQLRepositoryMethodModelBuilder
extends AbstractSQLModificationOperationReturningResultDataRepositoryMethodModelBuilder<Insert, SQLDataModelField, PostgreSQLDataObjectModelClass> {
    protected void validateMethod(ParsedSQL<Insert> parsedSQL, MethodResult methodResult, DataGenerationContext<SQLDataModelField, PostgreSQLDataObjectModelClass> dataGenerationContext, ExecutableElement method, DataMethodParams dataMethodParams) {
        super.validateMethod(parsedSQL, methodResult, dataGenerationContext, method, dataMethodParams);
        if (parsedSQL.doesNotContain("RETURNING")) {
            throw new InterruptProcessingException((Element)method, "Missing '?' keyword in the '?' statement", new Object[]{"RETURNING", "INSERT"});
        }
        if (parsedSQL.doesNotContain("SELECT")) {
            this.validateSingleReturnType(method, methodResult);
        }
    }

    protected ParsedSQL<Insert> parseSQL(ExecutableElement method, DataMethodParams dataMethodParams) {
        Insert annotation = method.getAnnotation(Insert.class);
        String originalSQL = Optional.of(annotation.value()).filter(v -> !v.isEmpty()).orElse("INSERT INTO ${table}(${inserted-columns}) VALUES(${values}) RETURNING ${id-columns}");
        return this.parseSQL(originalSQL, (Annotation)annotation);
    }

    protected String getTemplateName() {
        return "data/sql/r2dbc/postgresql/method/$$PostgreSQLRepositoryInsertWithReturningMethodBodyTemplate.javaftl";
    }

    public Class<? extends Annotation> operationType() {
        return Insert.class;
    }

    protected void addEntityConverter(MethodResult methodResult, SQLMethodDescriptor<SQLDataModelField, PostgreSQLDataObjectModelClass> sqlMethodDescriptor, DataGenerationContext<SQLDataModelField, PostgreSQLDataObjectModelClass> dataGenerationContext, List<Variable> params, SQLStatement sqlStatement, Map<String, Object> templateArguments) {
        super.addEntityConverter(methodResult, sqlMethodDescriptor, dataGenerationContext, params, sqlStatement, templateArguments);
        sqlMethodDescriptor.getEntityParam().ifPresent(modelClass -> modelClass.setInsertable(true));
    }
}

