/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.postgresql.component.impl.method;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataMethodParams;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl.AbstractSQLModificationOperationReturningResultDataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.sql.r2dbc.postgresql.model.PostgreSQLDataObjectModelClass;
import io.rxmicro.data.sql.operation.Delete;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

@Singleton
public final class PostgreSQLDeleteWithReturningSQLRepositoryMethodModelBuilder
extends AbstractSQLModificationOperationReturningResultDataRepositoryMethodModelBuilder<Delete, SQLDataModelField, PostgreSQLDataObjectModelClass> {
    protected void validateMethod(ParsedSQL<Delete> parsedSQL, MethodResult methodResult, DataGenerationContext<SQLDataModelField, PostgreSQLDataObjectModelClass> dataGenerationContext, ExecutableElement method, DataMethodParams dataMethodParams) {
        super.validateMethod(parsedSQL, methodResult, dataGenerationContext, method, dataMethodParams);
        if (parsedSQL.doesNotContain("RETURNING")) {
            throw new InterruptProcessingException((Element)method, "Missing '?' keyword in the '?' statement", new Object[]{"RETURNING", "INSERT"});
        }
        this.validateThatEntityContainsPrimaryKeyIfParamIsEntity(dataGenerationContext, method, dataMethodParams.getOtherParams());
    }

    protected ParsedSQL<Delete> parseSQL(ExecutableElement method, DataMethodParams dataMethodParams) {
        Delete annotation = method.getAnnotation(Delete.class);
        ParsedSQL parsedSQL = this.parseSQL(annotation.value(), (Annotation)annotation);
        if (parsedSQL.getSqlTokens().isEmpty()) {
            throw new InterruptProcessingException((Element)method, "Missing a delete SQL statement. Add it!", new Object[0]);
        }
        return parsedSQL;
    }

    protected String getTemplateName() {
        return "data/sql/r2dbc/postgresql/method/$$PostgreSQLRepositoryDeleteWithReturningMethodBodyTemplate.javaftl";
    }

    protected void addEntityConverter(MethodResult methodResult, SQLMethodDescriptor<SQLDataModelField, PostgreSQLDataObjectModelClass> sqlMethodDescriptor, DataGenerationContext<SQLDataModelField, PostgreSQLDataObjectModelClass> dataGenerationContext, List<Variable> params, SQLStatement sqlStatement, Map<String, Object> templateArguments) {
        super.addEntityConverter(methodResult, sqlMethodDescriptor, dataGenerationContext, params, sqlStatement, templateArguments);
        sqlMethodDescriptor.getEntityParam().ifPresent(modelClass -> {
            modelClass.setDeletable(true);
            templateArguments.put("IS_PRIMARY_KEY_SIMPLE", modelClass.getPrimaryKeysParams().size() == 1);
        });
    }

    public Class<? extends Annotation> operationType() {
        return Delete.class;
    }
}

