/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.postgresql.component.impl.builder;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.sql.component.SQLFieldsOrderExtractor;
import io.rxmicro.annotation.processor.data.sql.component.impl.SQLFieldsOrderValidator;
import io.rxmicro.annotation.processor.data.sql.component.impl.builder.AbstractModificationSQLBuilder;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.annotation.processor.data.sql.model.SelectedColumnFilter;
import io.rxmicro.annotation.processor.data.sql.r2dbc.postgresql.model.PostgreSQLDataObjectModelClass;
import io.rxmicro.data.sql.model.EntityFieldList;
import io.rxmicro.data.sql.model.EntityFieldMap;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public abstract class AbstractModificationPostgreSQLBuilder<A extends Annotation>
extends AbstractModificationSQLBuilder<A, SQLDataModelField, PostgreSQLDataObjectModelClass> {
    @Inject
    private SQLFieldsOrderExtractor sqlFieldsOrderExtractor;
    @Inject
    private SQLFieldsOrderValidator sqlFieldsOrderValidator;

    protected final boolean shouldAsteriskBeIgnored(int index, List<String> sqlTokens) {
        return index == 0 || !"RETURNING".equalsIgnoreCase(sqlTokens.get(index - 1));
    }

    protected void setResultColumns(ExecutableElement method, SQLStatement.Builder builder, List<String> sqlTokens, SQLMethodDescriptor<SQLDataModelField, PostgreSQLDataObjectModelClass> sqlMethodDescriptor) {
        int startIndex = this.getReturningKeywordIndex(sqlTokens);
        if (startIndex != -1) {
            List selectedColumns = this.sqlFieldsOrderExtractor.getSelectedColumns(sqlTokens, new SelectedColumnFilter.Builder().setStartIndex(startIndex + 1).build());
            if (selectedColumns.isEmpty()) {
                throw new InterruptProcessingException((Element)method, "Missing columns after '?' keyword", new Object[]{"RETURNING"});
            }
            this.sqlFieldsOrderValidator.validateSelectedColumn(method, selectedColumns);
            if (sqlMethodDescriptor.getEntityParam().isEmpty() && sqlMethodDescriptor.getEntityResult().isEmpty() && !sqlMethodDescriptor.getResult().isResultType(EntityFieldList.class) && !sqlMethodDescriptor.getResult().isResultType(EntityFieldMap.class)) {
                throw new InterruptProcessingException((Element)method, "Missing entity parameter or entity result for setting the returning column values", new Object[0]);
            }
            builder.setDefaultColumnOrder(false).setResultColumns(selectedColumns.stream().flatMap(c -> c.getCaption().stream()).collect(Collectors.toList()));
        }
    }

    private int getReturningKeywordIndex(List<String> sqlTokens) {
        for (int i = 0; i < sqlTokens.size(); ++i) {
            if (!"RETURNING".equalsIgnoreCase(sqlTokens.get(i))) continue;
            return i;
        }
        return -1;
    }
}

