/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.postgresql.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.component.DataRepositoryConfigAutoCustomizerBuilder;
import io.rxmicro.annotation.processor.data.model.DataRepositoryClassStructure;
import io.rxmicro.annotation.processor.data.sql.r2dbc.postgresql.model.PostgreSQLConfigAutoCustomizerClassStructure;
import io.rxmicro.common.util.ExCollections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Singleton
public final class PostgreSQLDataRepositoryConfigAutoCustomizerBuilder
implements DataRepositoryConfigAutoCustomizerBuilder {
    public Optional<ClassStructure> build(Set<DataRepositoryClassStructure> dataRepositoryClassStructures) {
        List<Map.Entry<TypeElement, String>> postgresEnumMapping = this.validateAndReturnPostgresEnumMappingWithoutDuplicates(dataRepositoryClassStructures.stream().flatMap(r -> r.getEnumMapping().stream()).collect(Collectors.toList()));
        return Optional.of(postgresEnumMapping).filter(l -> !l.isEmpty()).map(PostgreSQLConfigAutoCustomizerClassStructure::new);
    }

    private List<Map.Entry<TypeElement, String>> validateAndReturnPostgresEnumMappingWithoutDuplicates(List<Map.Entry<TypeElement, String>> postgresEnumMapping) {
        HashMap<String, Map.Entry<TypeElement, String>> classNames = new HashMap<String, Map.Entry<TypeElement, String>>();
        HashMap<String, Map.Entry<TypeElement, String>> dbTypeNames = new HashMap<String, Map.Entry<TypeElement, String>>();
        for (Map.Entry<TypeElement, String> entry : postgresEnumMapping) {
            String fullClassName = entry.getKey().getQualifiedName().toString();
            this.validateEnumClassNames(classNames, entry, fullClassName);
            this.validateDbTypeNames(dbTypeNames, entry, fullClassName);
        }
        return ExCollections.unmodifiableList(classNames.values());
    }

    private void validateEnumClassNames(Map<String, Map.Entry<TypeElement, String>> classNames, Map.Entry<TypeElement, String> entry, String fullClassName) {
        Map.Entry<TypeElement, String> processedEntry = classNames.get(fullClassName);
        if (processedEntry != null) {
            if (!entry.getValue().equals(processedEntry.getValue())) {
                throw new InterruptProcessingException((Element)entry.getKey(), "Detected two different db type names for the same enum class: ?, first db type name = ? and second db type name = ?!Set unique db type name per enum class!", new Object[]{fullClassName, entry.getValue(), processedEntry.getValue()});
            }
        } else {
            classNames.put(fullClassName, entry);
        }
    }

    private void validateDbTypeNames(Map<String, Map.Entry<TypeElement, String>> dbTypeNames, Map.Entry<TypeElement, String> entry, String fullClassName) {
        Map.Entry<TypeElement, String> processedEntry = dbTypeNames.get(entry.getValue());
        if (processedEntry != null) {
            if (!fullClassName.equals(processedEntry.getKey().getQualifiedName().toString())) {
                throw new InterruptProcessingException((Element)entry.getKey(), "Detected two different enum classes for the same db type name: ?, first enum class = ? and second enum class = ?!Set unique db type name per enum class!", new Object[]{fullClassName, entry.getValue(), processedEntry.getValue()});
            }
        } else {
            dbTypeNames.put(fullClassName, entry);
        }
    }
}

