/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.aggregator.model;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.data.model.DataRepositoryClassStructure;
import io.rxmicro.annotation.processor.data.model.DataRepositoryConfigAutoCustomizerClassStructure;
import io.rxmicro.annotation.processor.data.mongo.model.MongoRepositoryClassStructure;
import io.rxmicro.annotation.processor.data.sql.r2dbc.postgresql.model.PostgreSQLRepositoryClassStructure;
import io.rxmicro.config.detail.DefaultConfigValueBuilder;
import io.rxmicro.data.RepositoryFactory;
import io.rxmicro.data.mongo.detail.MongoRepositoryFactory;
import io.rxmicro.data.sql.r2dbc.postgresql.detail.PostgreSQLRepositoryFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class RepositoryFactoryClassStructure
extends ClassStructure {
    private final Set<DataRepositoryClassStructure> dataRepositoryClassStructures = new LinkedHashSet<DataRepositoryClassStructure>();
    private final Set<DataRepositoryConfigAutoCustomizerClassStructure> dataRepositoryConfigAutoCustomizerClassStructures = new LinkedHashSet<DataRepositoryConfigAutoCustomizerClassStructure>();
    private final List<MongoRepositoryClassStructure> mongoRepositories = new ArrayList<MongoRepositoryClassStructure>();
    private final List<PostgreSQLRepositoryClassStructure> postgreSQLRepositories = new ArrayList<PostgreSQLRepositoryClassStructure>();

    public RepositoryFactoryClassStructure(Set<? extends ClassStructure> classStructures) {
        for (ClassStructure classStructure : classStructures) {
            if (classStructure instanceof DataRepositoryConfigAutoCustomizerClassStructure) {
                this.dataRepositoryConfigAutoCustomizerClassStructures.add((DataRepositoryConfigAutoCustomizerClassStructure)classStructure);
                continue;
            }
            if (!(classStructure instanceof DataRepositoryClassStructure)) continue;
            this.dataRepositoryClassStructures.add((DataRepositoryClassStructure)classStructure);
            if (classStructure instanceof MongoRepositoryClassStructure) {
                this.mongoRepositories.add((MongoRepositoryClassStructure)classStructure);
                continue;
            }
            if (classStructure instanceof PostgreSQLRepositoryClassStructure) {
                this.postgreSQLRepositories.add((PostgreSQLRepositoryClassStructure)classStructure);
                continue;
            }
            throw new InternalErrorException("Unsupported data repository: " + classStructure, new Object[0]);
        }
    }

    public String getTargetFullClassName() {
        return GeneratedClassNames.getEntryPointFullClassName((String)RepositoryFactory.REPOSITORY_FACTORY_IMPL_CLASS_NAME);
    }

    public String getTemplateName() {
        return "data/aggregator/$$RepositoryFactoryImplTemplate.javaftl";
    }

    public Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IMPL_CLASS_NAME", RepositoryFactory.REPOSITORY_FACTORY_IMPL_CLASS_NAME);
        map.put("MONGO_REPOSITORIES", this.mongoRepositories);
        map.put("POSTGRE_SQL_REPOSITORIES", this.postgreSQLRepositories);
        map.put("ENVIRONMENT_CUSTOMIZER_CLASS", GeneratedClassNames.ENVIRONMENT_CUSTOMIZER_SIMPLE_CLASS_NAME);
        map.put("DEFAULT_CONFIG_VALUES", this.dataRepositoryClassStructures.stream().flatMap(s -> s.getDefaultConfigValues().stream()).collect(Collectors.toList()));
        map.put("CONFIG_AUTO_CUSTOMIZER_CLASSES", this.dataRepositoryConfigAutoCustomizerClassStructures);
        return map;
    }

    public ClassHeader getClassHeader() {
        ClassHeader.Builder builder = ClassHeader.newClassHeaderBuilder((String)"rxmicro").addImports(new Class[]{RepositoryFactory.class}).addStaticImport(DefaultConfigValueBuilder.class, "putDefaultConfigValue");
        this.addRepositoryImports(builder, this.mongoRepositories, MongoRepositoryFactory.class, "createMongoRepository");
        this.addRepositoryImports(builder, this.postgreSQLRepositories, PostgreSQLRepositoryFactory.class, "createPostgreSQLRepository");
        for (DataRepositoryConfigAutoCustomizerClassStructure classStructure : this.dataRepositoryConfigAutoCustomizerClassStructures) {
            builder.addImports(new String[]{classStructure.getTargetFullClassName()});
        }
        return builder.build();
    }

    private void addRepositoryImports(ClassHeader.Builder classHeaderBuilder, List<? extends DataRepositoryClassStructure> dataRepositories, Class<?> factoryClass, String factoryMethod) {
        if (!dataRepositories.isEmpty()) {
            classHeaderBuilder.addStaticImport(factoryClass, factoryMethod);
            for (DataRepositoryClassStructure dataRepositoryClassStructure : dataRepositories) {
                classHeaderBuilder.addImports(new String[]{dataRepositoryClassStructure.getFullInterfaceName(), dataRepositoryClassStructure.getTargetFullClassName()});
            }
        }
    }
}

