/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util.validators;

import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;

public final class VariableDefinitionValidators {
    public static void validateThatVariablesContainEvenItemCount(Element owner, Class<? extends Annotation> annotationClass, String parameterName, String ... variables) {
        if (variables.length % 2 == 1) {
            throw new InterruptProcessingException(owner, "'@?.?()' parameter must contains even item count: key1, value1, key2, value2,...", annotationClass.getSimpleName(), parameterName);
        }
    }

    public static void validateVariableNameFormat(Element owner, Class<? extends Annotation> annotationClass, String parameterName, String variableName) {
        boolean valid = true;
        if (!variableName.startsWith("${")) {
            valid = false;
        }
        if (!variableName.endsWith("}")) {
            valid = false;
        }
        if (variableName.lastIndexOf("${") != 0) {
            valid = false;
        }
        if (variableName.indexOf(125) != variableName.length() - 1) {
            valid = false;
        }
        if (!valid) {
            throw new InterruptProcessingException(owner, "'@?.?()' contains invalid variable name: Expected a string starts with '${' and ends with '}' tokens, but actual is: '?'! Example of valid variable names: ${name}, ${USER-HOME}, etc.", annotationClass.getSimpleName(), parameterName, variableName);
        }
    }

    private VariableDefinitionValidators() {
    }
}

