/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util.validators;

import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class TypeValidators {
    public static void validateThatElementIsPublic(Element element, String errorMessage, Object ... args) {
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new InterruptProcessingException(element, errorMessage, args);
        }
    }

    public static void validateExpectedElementKind(Element element, ElementKind expectedElementKind, String errorMessage, Object ... args) {
        if (element.getKind() != expectedElementKind) {
            throw new InterruptProcessingException(element, errorMessage, args);
        }
    }

    public static void validateNotNestedClass(TypeElement element, String errorMessage, Object ... args) {
        if (element.getNestingKind().isNested()) {
            throw new InterruptProcessingException(element, errorMessage, args);
        }
    }

    public static void validateNotAbstractClass(TypeElement element, String errorMessage, Object ... args) {
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new InterruptProcessingException(element, errorMessage, args);
        }
    }

    public static void validateNotSuperClass(TypeElement element, String errorMessage, Object ... args) {
        if (!Object.class.getName().equals(element.getSuperclass().toString())) {
            throw new InterruptProcessingException(element, errorMessage, args);
        }
    }

    public static void validateNotSuperInterfaces(TypeElement element, String errorMessage, Object ... args) {
        if (!element.getInterfaces().isEmpty()) {
            throw new InterruptProcessingException(element, errorMessage, args);
        }
    }

    public static void validateAccessibleDefaultConstructor(TypeElement typeElement) {
        if (typeElement.getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).noneMatch(e -> (e.getModifiers().isEmpty() || e.getModifiers().contains((Object)Modifier.PUBLIC) || e.getModifiers().contains((Object)Modifier.PROTECTED)) && "<init>".equals(e.getSimpleName().toString()) && e.getParameters().isEmpty())) {
            throw new InterruptProcessingException(typeElement, "Class '?' must declare a public or protected or default constructor without parameters", typeElement.asType());
        }
    }

    public static void validateAccessibleConstructor(ExecutableElement constructorElement) {
        if (!(constructorElement.getModifiers().isEmpty() || constructorElement.getModifiers().contains((Object)Modifier.PUBLIC) || constructorElement.getModifiers().contains((Object)Modifier.PROTECTED))) {
            throw new InterruptProcessingException(constructorElement, "Constructor must be a public or protected or default", new Object[0]);
        }
    }

    public static void validateTypeElement(Element owner, String validPrefix, TypeElement typeElement) {
        if (typeElement.getNestingKind().isNested()) {
            throw new InterruptProcessingException(owner, "?Model class couldn't be a nested class: ?", validPrefix, typeElement.getQualifiedName());
        }
        if (typeElement.getKind().isInterface()) {
            throw new InterruptProcessingException(owner, "?Model class couldn't be an interface: ?", validPrefix, typeElement.getQualifiedName());
        }
        if (typeElement.getKind() == ElementKind.ENUM) {
            throw new InterruptProcessingException(owner, "?Model class couldn't be an enum: ?", validPrefix, typeElement.getQualifiedName());
        }
        if (!typeElement.getTypeParameters().isEmpty()) {
            throw new InterruptProcessingException(owner, "?Model class couldn't be a parametrized class: ?", validPrefix, typeElement.getQualifiedName());
        }
    }

    public static void validateModuleDeclaration(ModuleElement ownerModule, Element owner, String validPrefix, TypeElement typeElement, boolean validateAllParents) {
        if (ownerModule.isUnnamed()) {
            return;
        }
        TypeElement currentTypeElement = typeElement;
        while (true) {
            ModuleElement resultModule;
            if (currentTypeElement.getEnclosedElements().stream().anyMatch(e -> e instanceof VariableElement) && ((resultModule = ProcessingEnvironmentHelper.getElements().getModuleOf(currentTypeElement)) == null || !ownerModule.getQualifiedName().equals(resultModule.getQualifiedName()))) {
                throw new InterruptProcessingException(owner, "?Model class '?' must be declared at '?' module", validPrefix, currentTypeElement.getQualifiedName(), ownerModule.getQualifiedName());
            }
            TypeMirror superClass = currentTypeElement.getSuperclass();
            if (Elements.superClassIsObject(superClass) || !validateAllParents) break;
            currentTypeElement = Elements.asTypeElement(superClass).orElseThrow();
        }
    }

    public static void validateGenericType(Element owner, TypeMirror type) {
        TypeValidators.validateGenericType(owner, type, null);
    }

    public static void validateGenericType(Element owner, TypeMirror type, String prefix) {
        String validPrefix;
        String string = validPrefix = prefix == null || prefix.isBlank() ? "" : prefix + ": ";
        if (!Elements.isGenericType(type)) {
            throw new InterruptProcessingException(owner, "?Expected generic type: ?", validPrefix, type);
        }
        int expectedCount = Elements.expectedGenericArgumentCount(type);
        if (type instanceof DeclaredType) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)type).getTypeArguments();
            if (expectedCount != typeArguments.size()) {
                throw new InterruptProcessingException(owner, "?Expected generic type with ? parameter(s): ?", validPrefix, expectedCount, type);
            }
            for (TypeMirror typeMirror : typeArguments) {
                if (typeMirror.getKind() == TypeKind.WILDCARD) {
                    throw new InterruptProcessingException(owner, "?Wildcard is not allowed: ?", validPrefix, type);
                }
                if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                    throw new InterruptProcessingException(owner, "?Type variable is not allowed: ?", validPrefix, type);
                }
                if (!Elements.isGenericType(typeMirror)) continue;
                TypeValidators.validateGenericType(owner, typeMirror, prefix);
            }
        } else {
            throw new InterruptProcessingException(owner, "?Expected declared type: ?", validPrefix, type);
        }
    }

    private TypeValidators() {
    }
}

