/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util.validators;

import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;

public final class MethodValidators {
    public static void validateNotPrivateMethod(ExecutableElement method, String errorMessage, Object ... args) {
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new InterruptProcessingException(method, errorMessage, args);
        }
    }

    public static void validateNotAbstractMethod(ExecutableElement method, String errorMessage, Object ... args) {
        if (method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new InterruptProcessingException(method, errorMessage, args);
        }
    }

    public static void validateStaticMethod(ExecutableElement method, String errorMessage, Object ... args) {
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new InterruptProcessingException(method, errorMessage, args);
        }
    }

    public static void validateNotStaticMethod(ExecutableElement method, String errorMessage, Object ... args) {
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new InterruptProcessingException(method, errorMessage, args);
        }
    }

    public static void validateNotSynchronizedMethod(ExecutableElement method, String errorMessage, Object ... args) {
        if (method.getModifiers().contains((Object)Modifier.SYNCHRONIZED)) {
            throw new InterruptProcessingException(method, errorMessage, args);
        }
    }

    public static void validateNotNativeMethod(ExecutableElement method, String errorMessage, Object ... args) {
        if (method.getModifiers().contains((Object)Modifier.NATIVE)) {
            throw new InterruptProcessingException(method, errorMessage, args);
        }
    }

    public static void validateNotDefaultMethod(ExecutableElement method, String errorMessage, Object ... args) {
        if (method.getModifiers().contains((Object)Modifier.DEFAULT)) {
            throw new InterruptProcessingException(method, errorMessage, args);
        }
    }

    public static void validateWithoutParametersMethod(ExecutableElement method, String errorMessage, Object ... args) {
        if (!method.getParameters().isEmpty()) {
            throw new InterruptProcessingException(method, errorMessage, args);
        }
    }

    private MethodValidators() {
    }
}

