/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util.validators;

import io.rxmicro.annotation.processor.common.model.SupportedAnnotations;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.common.meta.SupportedTypes;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypesException;

public final class AnnotationValidators {
    public static void validateNoAnnotationPerElement(Element element, Class<? extends Annotation> annotationType) {
        if (element.getAnnotationsByType(annotationType).length > 0 || element.getAnnotation(annotationType) != null) {
            throw new InterruptProcessingException(element, "Detected redundant annotation: '@?'. This annotation couldn't be used at the current context. Remove this annotation!", annotationType.getName());
        }
    }

    public static void validateOnlyOneAnnotationPerElement(Element element, List<? extends AnnotationMirror> annotations, SupportedAnnotations supportedAnnotations) {
        if (annotations.stream().filter(a -> supportedAnnotations.isAnnotationSupported(a.getAnnotationType())).count() > 1L) {
            throw new InterruptProcessingException(element, "Expected only one annotation per method. This annotation must be one from the following list: {?}", String.join((CharSequence)", ", supportedAnnotations.getNames()));
        }
    }

    public static void validateRedundantAnnotationsPerElement(Element element, List<? extends AnnotationMirror> annotations, SupportedAnnotations supportedAnnotations, String ownerName) {
        for (AnnotationMirror annotationMirror : annotations) {
            if (supportedAnnotations.isAnnotationSupported(annotationMirror.getAnnotationType())) continue;
            throw new InterruptProcessingException(element, "Detected redundant annotation: '@?'. ? can contain only the following annotations: {?}. Remove redundant annotation!", annotationMirror.getAnnotationType(), ownerName, String.join((CharSequence)", ", supportedAnnotations.getNames()));
        }
    }

    public static void validateNoRxMicroAnnotationsPerElement(Element element, String cause) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().startsWith("io.rxmicro.")) continue;
            throw new InterruptProcessingException(element, "Redundant annotation: '@?' because ?. Remote this annotation!", annotationMirror.getAnnotationType().toString(), cause);
        }
    }

    public static void validateCustomAnnotation(TypeElement annotationElement, Set<ElementType> allowedElementType) {
        AnnotationValidators.validateRetention(annotationElement);
        AnnotationValidators.validateTarget(annotationElement, allowedElementType);
    }

    public static void validateSupportedTypes(Element element, Class<? extends Annotation> annotationType) {
        List types;
        try {
            types = Arrays.stream(annotationType.getAnnotation(SupportedTypes.class).value()).map(AnnotationValidators::getClassName).collect(Collectors.toList());
        }
        catch (MirroredTypesException ex) {
            types = ex.getTypeMirrors().stream().map(Object::toString).collect(Collectors.toList());
        }
        if (!types.contains(element.asType().toString())) {
            throw new InterruptProcessingException(element, "Field type '?' not supported. Use one of the following: ?", element.asType(), types);
        }
    }

    private static String getClassName(Class<?> cl) {
        if (cl.isArray()) {
            return cl.getComponentType() + "[]";
        }
        return cl.getName();
    }

    public static void validateRetention(TypeElement annotationElement) {
        Retention retention = annotationElement.getAnnotation(Retention.class);
        if (retention == null) {
            throw new InterruptProcessingException(annotationElement, "Missing required @Retention annotation for '?' annotation type. Add it!", annotationElement.asType());
        }
        if (retention.value() != RetentionPolicy.SOURCE) {
            throw new InterruptProcessingException(annotationElement, "Invalid retention policy for '?' annotation type. Set 'RetentionPolicy.SOURCE' as retention policy for the custom qualifier annotation!", annotationElement.asType());
        }
    }

    private static void validateTarget(TypeElement annotationElement, Set<ElementType> allowedElementType) {
        Target target = annotationElement.getAnnotation(Target.class);
        if (target == null) {
            throw new InterruptProcessingException(annotationElement, "Missing required @Target annotation for '?' annotation type. Add it!", annotationElement.asType());
        }
        for (ElementType elementType : target.value()) {
            if (allowedElementType.isEmpty()) {
                throw new InterruptProcessingException(annotationElement, "Unsupported target element: '?' for '?' annotation type. Current annotation must have empty targets, i.e. @?({})", new Object[]{elementType, annotationElement.asType(), Target.class.getSimpleName()});
            }
            if (allowedElementType.contains((Object)elementType)) continue;
            throw new InterruptProcessingException(annotationElement, "Unsupported target element: '?' for '?' annotation type. The following elements supported only: ?", new Object[]{elementType, annotationElement.asType(), allowedElementType});
        }
    }

    private AnnotationValidators() {
    }
}

