/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util;

import io.rxmicro.common.util.Formats;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class Stubs {
    private static final Map<Class<?>, Object> DEFAULT_VALUES = Map.ofEntries(Map.entry(Optional.class, Optional.empty()), Map.entry(List.class, List.of()), Map.entry(Set.class, Set.of()), Map.entry(Collection.class, Set.of()), Map.entry(Iterable.class, Set.of()), Map.entry(Map.class, Map.of()), Map.entry(Boolean.class, false), Map.entry(Boolean.TYPE, false), Map.entry(Byte.class, (byte)0), Map.entry(Byte.TYPE, (byte)0), Map.entry(Short.class, (short)0), Map.entry(Short.TYPE, (short)0), Map.entry(Integer.class, 0), Map.entry(Integer.TYPE, 0), Map.entry(Long.class, 0L), Map.entry(Long.TYPE, 0L), Map.entry(Float.class, Float.valueOf(0.0f)), Map.entry(Float.TYPE, Float.valueOf(0.0f)), Map.entry(Double.class, 0.0), Map.entry(Double.TYPE, 0.0), Map.entry(BigDecimal.class, BigDecimal.ZERO), Map.entry(BigInteger.class, BigInteger.ZERO), Map.entry(String.class, ""), Map.entry(Character.class, Character.valueOf('0')), Map.entry(Character.TYPE, Character.valueOf('0')));

    public static <T> T stub(Class<T> interfaceClass) {
        return Stubs.stub(interfaceClass, MethodHandles.lookup());
    }

    public static <T> T stub(Class<T> interfaceClass, MethodHandles.Lookup lookup) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new StubsInvocationHandler<T>(interfaceClass, lookup));
    }

    private Stubs() {
    }

    private static final class StubsInvocationHandler<T>
    implements InvocationHandler {
        private final Class<T> interfaceClass;
        private final MethodHandles.Lookup lookup;

        private StubsInvocationHandler(Class<T> interfaceClass, MethodHandles.Lookup lookup) {
            this.interfaceClass = interfaceClass;
            this.lookup = lookup;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName()) && method.getParameterCount() == 0) {
                return Formats.format((String)"? Stub", (Object[])new Object[]{this.interfaceClass.getSimpleName()});
            }
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if (method.isDefault()) {
                return this.lookup.findSpecial(this.interfaceClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), this.interfaceClass).bindTo(proxy).invokeWithArguments(args);
            }
            Class<?> returnType = method.getReturnType();
            if (returnType.isEnum()) {
                ?[] enumConstants = returnType.getEnumConstants();
                return enumConstants.length > 0 ? enumConstants[0] : null;
            }
            return DEFAULT_VALUES.get(returnType);
        }
    }
}

