/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util;

import io.rxmicro.common.util.Requires;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public final class SortedOperatorMapBuilder {
    private final Collection<String> operators;

    public SortedOperatorMapBuilder(Collection<String> operators) {
        this.operators = (Collection)Requires.require(operators);
    }

    public Map<String, SortedSet<String>> buildUnmodifiableMapWithSortedValues(Comparator<String> comparator) {
        HashMap<String, SortedSet<String>> operatorMap = new HashMap<String, SortedSet<String>>();
        for (String operator : this.operators) {
            String key = String.valueOf(operator.charAt(0));
            SortedSet set = operatorMap.computeIfAbsent(key, k -> new TreeSet(comparator));
            if (key.equals(operator)) continue;
            set.add(operator);
        }
        return this.unmodifiableMap(operatorMap);
    }

    private Map<String, SortedSet<String>> unmodifiableMap(Map<String, SortedSet<String>> operatorMap) {
        operatorMap.replaceAll((k, v) -> Collections.unmodifiableSortedSet(v));
        return Map.copyOf(operatorMap);
    }
}

