/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.lang.model.type.TypeMirror;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Reactives {
    public static boolean isMono(TypeMirror reactiveType) {
        return Mono.class.getName().equals(ProcessingEnvironmentHelper.getTypes().erasure(reactiveType).toString());
    }

    public static boolean isFlux(TypeMirror reactiveType) {
        return Flux.class.getName().equals(ProcessingEnvironmentHelper.getTypes().erasure(reactiveType).toString());
    }

    public static boolean isSpringReactorType(TypeMirror reactiveType) {
        return Reactives.isMono(reactiveType) || Reactives.isFlux(reactiveType);
    }

    public static boolean isFuture(TypeMirror reactiveType) {
        TypeMirror typeMirror = ProcessingEnvironmentHelper.getTypes().erasure(reactiveType);
        return CompletionStage.class.getName().equals(typeMirror.toString()) || CompletableFuture.class.getName().equals(typeMirror.toString());
    }

    public static boolean isMaybe(TypeMirror reactiveType) {
        return Maybe.class.getName().equals(ProcessingEnvironmentHelper.getTypes().erasure(reactiveType).toString());
    }

    public static boolean isSingle(TypeMirror reactiveType) {
        return Single.class.getName().equals(ProcessingEnvironmentHelper.getTypes().erasure(reactiveType).toString());
    }

    public static boolean isFlowable(TypeMirror reactiveType) {
        return Flowable.class.getName().equals(ProcessingEnvironmentHelper.getTypes().erasure(reactiveType).toString());
    }

    public static boolean isCompletable(TypeMirror reactiveType) {
        return Completable.class.getName().equals(ProcessingEnvironmentHelper.getTypes().erasure(reactiveType).toString());
    }

    public static boolean isRxJavaType(TypeMirror reactiveType) {
        return Reactives.isMaybe(reactiveType) || Reactives.isSingle(reactiveType) || Reactives.isFlowable(reactiveType) || Reactives.isCompletable(reactiveType);
    }

    private Reactives() {
    }
}

