/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util;

import io.rxmicro.annotation.processor.common.util.proxy.ProxyElements;
import io.rxmicro.annotation.processor.common.util.proxy.ProxyMessager;
import io.rxmicro.annotation.processor.common.util.proxy.ProxyTypes;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Requires;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public final class ProcessingEnvironmentHelper {
    private static final String ERROR_TEMPLATE = "? is not initialized yet";
    private static ProcessingEnvironment processingEnvironment;
    private static int compilationErrors;
    private static Elements elements;
    private static Types types;
    private static Filer filer;
    private static Messager messager;
    private static Map<String, String> compilerOptions;

    public static void init(ProcessingEnvironment processingEnv) {
        processingEnvironment = processingEnv;
        elements = new ProxyElements(processingEnv.getElementUtils());
        types = new ProxyTypes(processingEnv.getTypeUtils());
        messager = new ProxyMessager(processingEnv.getMessager());
        filer = processingEnv.getFiler();
        compilerOptions = ExCollections.unmodifiableOrderedMap(processingEnv.getOptions());
        compilationErrors = 0;
    }

    public static ProcessingEnvironment getProcessingEnvironment() {
        return processingEnvironment;
    }

    public static Elements getElements() {
        return (Elements)Requires.require((Object)elements, (String)ERROR_TEMPLATE, (Object[])new Object[]{ProcessingEnvironmentHelper.class.getName()});
    }

    public static Types getTypes() {
        return (Types)Requires.require((Object)types, (String)ERROR_TEMPLATE, (Object[])new Object[]{ProcessingEnvironmentHelper.class.getName()});
    }

    public static Filer getFiler() {
        return (Filer)Requires.require((Object)filer, (String)ERROR_TEMPLATE, (Object[])new Object[]{ProcessingEnvironmentHelper.class.getName()});
    }

    public static Messager getMessager() {
        return (Messager)Requires.require((Object)messager, (String)ERROR_TEMPLATE, (Object[])new Object[]{ProcessingEnvironmentHelper.class.getName()});
    }

    public static Map<String, String> getCompilerOptions() {
        return (Map)Requires.require(compilerOptions, (String)ERROR_TEMPLATE, (Object[])new Object[]{ProcessingEnvironmentHelper.class.getName()});
    }

    public static boolean doesContainCompilationErrors() {
        return compilationErrors > 0;
    }

    public static boolean doesNotContainCompilationErrors() {
        return compilationErrors == 0;
    }

    public static void aNewCompilationErrorDetected() {
        ++compilationErrors;
    }

    private ProcessingEnvironmentHelper() {
    }
}

