/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util;

import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class Names {
    public static String getPackageName(TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            throw new InternalErrorException("Primitive not allowed here", new Object[0]);
        }
        return Names.getPackageName(Names.getTypeWithoutGeneric(type));
    }

    public static String getPackageName(TypeElement typeElement) {
        return Names.getPackageName(typeElement.getQualifiedName().toString());
    }

    public static String getPackageName(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            throw new InternalErrorException("Package <default> not allowed", new Object[0]);
        }
        return className.substring(0, lastDot);
    }

    public static String getSimpleName(TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            throw new InternalErrorException("Primitive not allowed here", new Object[0]);
        }
        StringBuilder nameBuilder = new StringBuilder();
        Names.populate(nameBuilder, type);
        return nameBuilder.toString();
    }

    public static String getSimpleName(TypeElement typeElement) {
        return Names.getSimpleName(typeElement.getSimpleName().toString());
    }

    public static String getSimpleName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return index > 0 ? fullClassName.substring(index + 1) : fullClassName;
    }

    public static String getDefaultVarName(String fullClassName) {
        String simpleName = Names.getSimpleName(fullClassName);
        if (simpleName.length() > 1) {
            return Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
        }
        return String.valueOf(Character.toLowerCase(simpleName.charAt(0)));
    }

    public static String getGenericType(TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            throw new InternalErrorException("Primitive not allowed here", new Object[0]);
        }
        String string = type.toString();
        return string.substring(string.indexOf(60) + 1, string.lastIndexOf(62));
    }

    public static String getTypeWithoutGeneric(TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            throw new InternalErrorException("Primitive not allowed here", new Object[0]);
        }
        String string = type.toString();
        int index = string.indexOf(60);
        return index > 0 ? string.substring(0, index) : string;
    }

    public static String getTypeWithoutGeneric(String type) {
        int index = type.indexOf(60);
        return index > 0 ? type.substring(0, index) : type;
    }

    private static void populate(StringBuilder nameBuilder, TypeMirror type) {
        nameBuilder.append(Names.getSimpleName(ProcessingEnvironmentHelper.getTypes().erasure(type).toString()));
        if (type instanceof DeclaredType) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)type).getTypeArguments();
            if (!typeArguments.isEmpty()) {
                nameBuilder.append('<');
            }
            for (int i = 0; i < typeArguments.size(); ++i) {
                TypeMirror typeArgument = typeArguments.get(i);
                Names.populate(nameBuilder, typeArgument);
                if (i == typeArguments.size() - 1) continue;
                nameBuilder.append(", ");
            }
            if (!typeArguments.isEmpty()) {
                nameBuilder.append('>');
            }
        }
    }

    private Names() {
    }
}

