/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util;

import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import io.rxmicro.common.local.DeniedPackages;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class ModelTypeElements {
    public static TypeElement asValidatedModelTypeElement(ModuleElement currentModule, Element owner, TypeMirror type, String prefix, ModelFieldBuilderOptions options) {
        String validPrefix = prefix == null || prefix.isEmpty() ? "" : prefix + ": ";
        Optional<TypeElement> optionalTypeElement = Elements.asTypeElement(type);
        if (optionalTypeElement.isPresent()) {
            TypeElement typeElement = optionalTypeElement.get();
            if (!Elements.isVirtualTypeElement(typeElement)) {
                if (DeniedPackages.isDeniedPackage((String)typeElement.getQualifiedName().toString())) {
                    throw new InterruptProcessingException(owner, "?Model class couldn't be a library class: ?. Create a custom class at the current module", validPrefix, typeElement.getQualifiedName());
                }
                TypeValidators.validateTypeElement(owner, validPrefix, typeElement);
                if (options.isRequireDefConstructor()) {
                    TypeValidators.validateAccessibleDefaultConstructor(typeElement);
                }
                TypeValidators.validateModuleDeclaration(currentModule, owner, validPrefix, typeElement, options.isWithFieldsFromParentClasses());
            }
            return typeElement;
        }
        throw new InterruptProcessingException(owner, "?? is not a class", validPrefix, type);
    }

    private ModelTypeElements() {
    }
}

