/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util;

import io.rxmicro.annotation.processor.common.model.LoggableClassName;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.common.util.Formats;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public final class LoggerMessages {
    public static final String LOG_MESSAGE_LINE_DELIMITER = "------------------------------------------------------------------------";
    public static final String DEFAULT_OFFSET = "  ";

    public static String getLoggableParentChildRelationFragment(int repeatOffset, boolean showParent, LoggableClassName parentClass, LoggableClassName childClass) {
        int rowHead = 94;
        String rowTail = "|-";
        int offsetValue = repeatOffset * 3 + 1;
        return (String)(showParent ? DEFAULT_OFFSET.repeat(offsetValue) + parentClass.getLoggableFullClassName() + "\n" : "") + DEFAULT_OFFSET.repeat(offsetValue) + "  ^\n" + DEFAULT_OFFSET.repeat(offsetValue) + "  |-  " + childClass.getLoggableFullClassName();
    }

    public static String getAlignedWithLineDelimiterMessage(String template, Object ... args) {
        String message = Formats.format((String)template, (Object[])args);
        int length = LOG_MESSAGE_LINE_DELIMITER.length();
        if (message.length() == length) {
            return message;
        }
        if (message.length() > length) {
            return message.substring(0, length);
        }
        if (message.length() + 2 < length) {
            int leftRepeat = (length - message.length() - 2) / 2;
            int rightRepeat = length - message.length() - 2 - leftRepeat;
            return "-".repeat(leftRepeat) + " " + message + " " + "-".repeat(rightRepeat);
        }
        return message;
    }

    public static String getLoggableMethodName(ExecutableElement method) {
        return Formats.format((String)"?(?)", (Object[])new Object[]{method.getSimpleName(), method.getParameters().stream().map(v -> {
            TypeMirror typeMirror = v.asType();
            if (typeMirror.getKind().isPrimitive()) {
                return Formats.format((String)"? ?", (Object[])new Object[]{typeMirror, v.getSimpleName()});
            }
            return Formats.format((String)"? ?", (Object[])new Object[]{Names.getSimpleName(typeMirror), v.getSimpleName()});
        }).collect(Collectors.joining(", "))});
    }

    private LoggerMessages() {
    }
}

