/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util;

import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.common.util.Formats;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class GeneratedClassNames {
    public static final String ENVIRONMENT_CUSTOMIZER_SIMPLE_CLASS_NAME = Formats.format((String)"?EnvironmentCustomizer", (Object[])new Object[]{"$$"});
    public static final String REFLECTIONS_SIMPLE_CLASS_NAME = Formats.format((String)"?Reflections", (Object[])new Object[]{"$$"});
    public static final String REFLECTIONS_FULL_CLASS_NAME = GeneratedClassNames.getEntryPointFullClassName(REFLECTIONS_SIMPLE_CLASS_NAME);

    public static String getEntryPointFullClassName(String simpleClassName) {
        return Formats.format((String)"?.?", (Object[])new Object[]{"rxmicro", simpleClassName});
    }

    public static String getModelTransformerInstanceName(TypeMirror typeMirror, Class<?> baseTransformerClass) {
        return GeneratedClassNames.getModelTransformerInstanceName(Names.getSimpleName(typeMirror), baseTransformerClass);
    }

    public static String getModelTransformerInstanceName(TypeElement typeElement, Class<?> baseTransformerClass) {
        return GeneratedClassNames.getModelTransformerInstanceName(typeElement.asType(), baseTransformerClass);
    }

    public static String getModelTransformerInstanceName(String modelSimpleName, Class<?> baseTransformerClass) {
        return Formats.format((String)"??", (Object[])new Object[]{Names.getDefaultVarName(modelSimpleName.startsWith("$$") ? modelSimpleName.substring(2) : modelSimpleName), baseTransformerClass.getSimpleName()});
    }

    public static String getModelTransformerSimpleClassName(TypeElement typeElement, Class<?> baseTransformerClass) {
        String simpleName = typeElement.getSimpleName().toString();
        if (simpleName.startsWith("$$")) {
            return Formats.format((String)"??", (Object[])new Object[]{simpleName, baseTransformerClass.getSimpleName()});
        }
        return Formats.format((String)"???", (Object[])new Object[]{"$$", simpleName, baseTransformerClass.getSimpleName()});
    }

    public static String getModelTransformerSimpleClassName(String modelSimpleName, Class<?> baseTransformerClass) {
        if (modelSimpleName.startsWith("$$")) {
            return Formats.format((String)"??", (Object[])new Object[]{modelSimpleName, baseTransformerClass.getSimpleName()});
        }
        return Formats.format((String)"???", (Object[])new Object[]{"$$", modelSimpleName, baseTransformerClass.getSimpleName()});
    }

    public static String getModelTransformerFullClassName(String packageName, String modelSimpleName, Class<?> baseTransformerClass) {
        return Formats.format((String)"?.?", (Object[])new Object[]{packageName, GeneratedClassNames.getModelTransformerSimpleClassName(modelSimpleName, baseTransformerClass)});
    }

    public static String getModelTransformerFullClassName(TypeElement typeElement, Class<?> baseTransformerClass) {
        return Formats.format((String)"?.?", (Object[])new Object[]{Names.getPackageName(typeElement), GeneratedClassNames.getModelTransformerSimpleClassName(typeElement, baseTransformerClass)});
    }

    private GeneratedClassNames() {
    }
}

