/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util;

import io.rxmicro.annotation.processor.common.model.virtual.VirtualTypeElement;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualTypeMirror;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.local.DeniedPackages;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.common.util.Strings;
import io.rxmicro.model.NotStandardSerializableEnum;
import io.rxmicro.model.Transient;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;

public final class Elements {
    public static final Comparator<TypeElement> UNIQUE_TYPES_COMPARATOR = Comparator.comparing(o -> o.getQualifiedName().toString());
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_NOT_BOOLEAN_PREFIX = "get";
    private static final String GETTER_BOOLEAN_PREFIX = "is";

    public static Set<String> getAllowedEnumConstants(TypeMirror typeMirror) {
        return Elements.asEnumElement(typeMirror).map(Elements::getAllowedEnumConstants).orElse(Set.of());
    }

    public static Set<String> getAllowedEnumConstants(TypeElement typeElement) {
        return (Set)typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.ENUM_CONSTANT).map(e -> e.getSimpleName().toString()).collect(ExCollectors.toUnmodifiableOrderedSet());
    }

    public static int expectedGenericArgumentCount(TypeMirror typeMirror) {
        return Elements.asTypeElement(typeMirror).map(te -> te.getTypeParameters().size()).orElse(0);
    }

    public static boolean isGenericType(TypeMirror typeMirror) {
        return Elements.asTypeElement(typeMirror).map(te -> !te.getTypeParameters().isEmpty()).orElse(false);
    }

    public static boolean isVirtualTypeElement(TypeElement typeElement) {
        return typeElement instanceof VirtualTypeElement;
    }

    public static boolean isNotStandardEnum(TypeMirror typeMirror) {
        return Elements.asEnumElement(typeMirror).map(te -> te.getInterfaces().stream().anyMatch(i -> NotStandardSerializableEnum.class.getName().equals(i.toString()))).orElse(false);
    }

    public static List<VariableElement> allModelFields(TypeElement typeElement) {
        return Elements.allModelFields(typeElement, true);
    }

    public static List<VariableElement> allModelFields(TypeElement typeElement, boolean withFieldsFromParentClasses) {
        Set<Modifier> excludeModifiers = Set.of(Modifier.STATIC, Modifier.TRANSIENT, Modifier.VOLATILE);
        return Elements.allFields(typeElement, withFieldsFromParentClasses, el -> el.getModifiers().stream().noneMatch(excludeModifiers::contains) && el.getAnnotation(Transient.class) == null);
    }

    public static List<VariableElement> allFields(TypeElement typeElement, Predicate<VariableElement> filter) {
        return Elements.allFields(typeElement, true, filter);
    }

    public static List<VariableElement> allFields(TypeElement typeElement, boolean withFieldsFromParentClasses, Predicate<VariableElement> filter) {
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
        TypeElement currentTypeElement = typeElement;
        while (true) {
            fields.addAll(0, currentTypeElement.getEnclosedElements().stream().filter(el -> el.getKind() == ElementKind.FIELD).map(el -> (VariableElement)el).filter(filter).collect(Collectors.toList()));
            TypeMirror superClass = currentTypeElement.getSuperclass();
            if (Elements.superClassIsObject(superClass) || !withFieldsFromParentClasses) break;
            currentTypeElement = Elements.asTypeElement(superClass).orElseThrow();
        }
        return fields;
    }

    public static List<ExecutableElement> allConstructors(TypeElement typeElement) {
        return Elements.allConstructors(typeElement, e -> true);
    }

    public static List<ExecutableElement> allConstructors(TypeElement typeElement, Predicate<ExecutableElement> filter) {
        return typeElement.getEnclosedElements().stream().filter(el -> el.getKind() == ElementKind.CONSTRUCTOR).map(el -> (ExecutableElement)el).filter(filter).collect(Collectors.toList());
    }

    public static List<ExecutableElement> allMethodsFromType(TypeElement typeElement) {
        return Elements.allMethodsFromType(typeElement, e -> true);
    }

    public static List<ExecutableElement> allMethodsFromType(TypeElement typeElement, Predicate<ExecutableElement> filter) {
        return typeElement.getEnclosedElements().stream().filter(el -> el.getKind() == ElementKind.METHOD).map(el -> (ExecutableElement)el).filter(filter).collect(Collectors.toList());
    }

    public static List<ExecutableElement> allImplementableMethods(TypeElement typeElement) {
        return Elements.allMethods(typeElement, e -> {
            if (e.getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().toString().startsWith("io.rxmicro."))) {
                return true;
            }
            return Set.of(Modifier.STATIC, Modifier.PRIVATE, Modifier.DEFAULT).stream().noneMatch(m -> e.getModifiers().contains(m));
        });
    }

    public static List<ExecutableElement> allMethods(TypeElement typeElement) {
        return Elements.allMethods(typeElement, e -> true);
    }

    public static List<ExecutableElement> allMethods(TypeElement typeElement, Predicate<ExecutableElement> filter) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        TypeElement currentTypeElement = typeElement;
        while (true) {
            methods.addAll(0, currentTypeElement.getEnclosedElements().stream().filter(el -> el.getKind() == ElementKind.METHOD).map(el -> (ExecutableElement)el).filter(filter).collect(Collectors.toList()));
            TypeMirror superClass = currentTypeElement.getSuperclass();
            if (Elements.superClassIsObject(superClass)) break;
            currentTypeElement = Elements.asTypeElement(superClass).orElseThrow();
        }
        return methods;
    }

    public static Set<String> allDeclaredProperties(TypeElement typeElement) {
        return (Set)Elements.allMethods(typeElement, e -> e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getSimpleName().toString().startsWith(SETTER_PREFIX) && e.getParameters().size() == 1).stream().map(e -> e.getSimpleName().toString()).filter(name -> name.length() > 3).map(name -> Strings.unCapitalize((String)name.substring(3))).collect(ExCollectors.toUnmodifiableOrderedSet());
    }

    public static boolean superClassIsObject(TypeMirror superClass) {
        return superClass instanceof NoType || Object.class.getName().equals(superClass.toString());
    }

    public static Optional<TypeElement> asTypeElement(TypeMirror typeMirror) {
        if (typeMirror instanceof VirtualTypeMirror) {
            return Optional.of(((VirtualTypeMirror)typeMirror).getVirtualTypeElement());
        }
        return Optional.ofNullable(ProcessingEnvironmentHelper.getTypes().asElement(typeMirror)).filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e);
    }

    public static Optional<TypeElement> asEnumElement(TypeMirror typeMirror) {
        return Elements.asTypeElement(typeMirror).filter(e -> e.getKind() == ElementKind.ENUM);
    }

    public static List<ExecutableElement> findGetters(TypeElement typeElement, VariableElement variableElement) {
        return Elements.findGetterOrSetter(typeElement, variableElement, true);
    }

    public static List<ExecutableElement> findSetters(TypeElement typeElement, VariableElement variableElement) {
        return Elements.findGetterOrSetter(typeElement, variableElement, false);
    }

    public static Optional<ExecutableElement> findSetter(TypeElement typeElement, String propertyName) {
        Set<String> methodNames = Elements.getSettersOrGettersMethodNames(false, propertyName);
        TypeElement currentTypeElement = typeElement;
        while (true) {
            List methods;
            if (!(methods = currentTypeElement.getEnclosedElements().stream().filter(el -> el.getKind() == ElementKind.METHOD && !el.getModifiers().contains((Object)Modifier.STATIC) && methodNames.contains(el.getSimpleName().toString()) && el.getModifiers().contains((Object)Modifier.PUBLIC)).map(e -> (ExecutableElement)e).filter(el -> el.getParameters().size() == 1).collect(Collectors.toList())).isEmpty()) {
                return Optional.of((ExecutableElement)methods.get(0));
            }
            TypeMirror superClass = currentTypeElement.getSuperclass();
            if (Elements.superClassIsObject(superClass)) break;
            currentTypeElement = Elements.asTypeElement(superClass).orElseThrow();
        }
        return Optional.empty();
    }

    private static List<ExecutableElement> findGetterOrSetter(TypeElement typeElement, VariableElement variableElement, boolean getter) {
        String fieldType = variableElement.asType().toString();
        String fieldName = variableElement.getSimpleName().toString();
        Set<String> methodNames = Elements.getSettersOrGettersMethodNames(getter, fieldName);
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        TypeElement currentTypeElement = typeElement;
        while (true) {
            methods.addAll(currentTypeElement.getEnclosedElements().stream().filter(el -> el.getKind() == ElementKind.METHOD && !el.getModifiers().contains((Object)Modifier.STATIC) && methodNames.contains(el.getSimpleName().toString()) && el.getModifiers().contains((Object)Modifier.PUBLIC)).map(e -> (ExecutableElement)e).filter(el -> getter ? el.getReturnType().toString().equals(fieldType) : el.getParameters().size() == 1 && el.getParameters().get(0).asType().toString().equals(fieldType)).collect(Collectors.toList()));
            TypeMirror superClass = currentTypeElement.getSuperclass();
            if (Elements.superClassIsObject(superClass)) break;
            currentTypeElement = Elements.asTypeElement(superClass).orElseThrow();
        }
        return methods;
    }

    private static Set<String> getSettersOrGettersMethodNames(boolean getter, String fieldName) {
        if (getter) {
            return Set.copyOf(List.of(GETTER_NOT_BOOLEAN_PREFIX + Strings.capitalize((String)fieldName), GETTER_NOT_BOOLEAN_PREFIX + fieldName, GETTER_BOOLEAN_PREFIX + Strings.capitalize((String)fieldName), GETTER_BOOLEAN_PREFIX + fieldName));
        }
        return Set.copyOf(List.of(SETTER_PREFIX + Strings.capitalize((String)fieldName), SETTER_PREFIX + fieldName));
    }

    public static boolean methodSignatureEquals(ExecutableElement method1, ExecutableElement method2) {
        return method2.getSimpleName().toString().equals(method1.getSimpleName().toString()) && method2.getParameters().stream().map(v -> v.asType().toString()).collect(Collectors.toList()).equals(method1.getParameters().stream().map(v -> v.asType().toString()).collect(Collectors.toList()));
    }

    public static boolean doesExtendSuperType(TypeElement type, Class<?> expectedSuperType) {
        return Elements.findSuperType(type, expectedSuperType).isPresent();
    }

    public static Optional<? extends TypeMirror> findSuperType(TypeElement type, Class<?> expectedSuperType) {
        TypeElement currentTypeElement = type;
        Optional<TypeMirror> first;
        while (!(first = currentTypeElement.getInterfaces().stream().filter(t -> ProcessingEnvironmentHelper.getTypes().erasure((TypeMirror)t).toString().equals(expectedSuperType.getName())).findFirst()).isPresent()) {
            TypeMirror superClass = currentTypeElement.getSuperclass();
            if (Elements.superClassIsObject(superClass)) {
                return Optional.empty();
            }
            if (ProcessingEnvironmentHelper.getTypes().erasure(superClass).toString().equals(expectedSuperType.getName())) {
                return Optional.of(superClass);
            }
            currentTypeElement = Elements.asTypeElement(superClass).orElseThrow();
        }
        return first;
    }

    public static List<TypeElement> allSuperTypes(TypeElement type) {
        TypeMirror superClass;
        ArrayList<TypeElement> list = new ArrayList<TypeElement>();
        TypeElement currentTypeElement = type;
        while (!Elements.superClassIsObject(superClass = currentTypeElement.getSuperclass()) && !DeniedPackages.isDeniedPackage((String)Names.getPackageName(currentTypeElement = Elements.asTypeElement(superClass).orElseThrow()))) {
            list.add(currentTypeElement);
        }
        return list;
    }

    public static SortedSet<TypeElement> allSuperTypesAndInterfaces(TypeElement type, boolean withThis, boolean excludeLibClasses) {
        TreeSet<TypeElement> result = new TreeSet<TypeElement>(Comparator.comparing(o -> o.getQualifiedName().toString()));
        if (withThis) {
            result.add(type);
        }
        HashSet<String> names = new HashSet<String>();
        TypeElement currentTypeElement = type;
        while (true) {
            currentTypeElement.getInterfaces().stream().filter(t -> !excludeLibClasses || !DeniedPackages.isDeniedPackage((String)Names.getPackageName(t))).flatMap(t -> Elements.asTypeElement(t).stream()).forEach(te -> {
                if (names.add(te.getQualifiedName().toString())) {
                    result.add((TypeElement)te);
                }
            });
            TypeMirror superClass = currentTypeElement.getSuperclass();
            if (Elements.superClassIsObject(superClass)) break;
            currentTypeElement = Elements.asTypeElement(superClass).orElseThrow();
            if (excludeLibClasses && DeniedPackages.isDeniedPackage((String)Names.getPackageName(currentTypeElement)) || !names.add(currentTypeElement.getQualifiedName().toString())) continue;
            result.add(currentTypeElement);
        }
        return result;
    }

    private Elements() {
    }
}

