/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.util;

import io.rxmicro.annotation.processor.common.model.DefaultConfigProxyValue;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.meta.ReadMore;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Strings;
import io.rxmicro.config.Config;
import io.rxmicro.config.DefaultConfigValue;
import io.rxmicro.config.DefaultConfigValueSupplier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;

public final class Annotations {
    public static <T extends Annotation> T getRequiredAnnotation(AnnotatedConstruct annotated, Class<T> annotationClass) {
        return (T)((Annotation)Optional.ofNullable(annotated.getAnnotation(annotationClass)).orElseThrow(Errors.createInternalErrorSupplier("'?' annotated element is not annotated by the required '@?' annotation!", annotated, annotationClass.getName())));
    }

    public static <T extends Annotation> T getPresentOrDefaultAnnotation(AnnotatedConstruct annotated, Class<T> annotationClass) {
        return (T)Optional.ofNullable(annotated.getAnnotation(annotationClass)).orElseGet(() -> Annotations.defaultAnnotationInstance(annotationClass));
    }

    public static Optional<ReadMore> getReadMore(Class<? extends Annotation> annotationClass) {
        return Optional.ofNullable(annotationClass.getAnnotation(ReadMore.class));
    }

    public static <T extends Annotation> T defaultAnnotationInstance(Class<T> annotationClass) {
        Object mock = new Object();
        return (T)((Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (proxy, method, args) -> {
            if ("toString".equals(method.getName()) && method.getParameterCount() == 0) {
                return Formats.format((String)"? Proxy", (Object[])new Object[]{annotationClass.getSimpleName()});
            }
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke(mock, args);
            }
            return method.getDefaultValue();
        }));
    }

    public static Object getAnnotationValue(Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues, String valueName) {
        return elementValues.entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().toString().equals(valueName)).findFirst().map(e -> ((AnnotationValue)e.getValue()).getValue()).orElseThrow(Errors.createInternalErrorSupplier("Expected required annotation parameter with name: '?'", valueName));
    }

    public static Object getAnnotationValue(Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues) {
        return Annotations.getAnnotationValue(elementValues, "value");
    }

    public static TypeElement getAnnotationElement(AnnotationMirror annotation) {
        return Elements.asTypeElement(annotation.getAnnotationType()).orElseThrow();
    }

    public static Optional<TypeElement> getAnnotationClassParameter(Supplier<Class<?>> classSupplier, Class<?> excludeClass) {
        TypeElement type;
        try {
            type = ProcessingEnvironmentHelper.getElements().getTypeElement(classSupplier.get().getName());
        }
        catch (MirroredTypeException ex) {
            type = Elements.asTypeElement(ex.getTypeMirror()).orElse(null);
        }
        return Optional.ofNullable(type).filter(t -> !excludeClass.getName().equals(t.getQualifiedName().toString()));
    }

    public static Optional<TypeElement> getAnnotationClassParameter(Supplier<Class<?>> classSupplier) {
        return Annotations.getAnnotationClassParameter(classSupplier, Void.class);
    }

    public static TypeElement getRequiredAnnotationClassParameter(Supplier<Class<?>> classSupplier) {
        return Annotations.getAnnotationClassParameter(classSupplier, Void.class).orElseThrow();
    }

    public static List<Map.Entry<String, DefaultConfigProxyValue>> getValidatedDefaultConfigValues(String defaultConfigNameSpace, TypeElement configClass, Element element) {
        List<Map.Entry<String, DefaultConfigProxyValue>> values = Annotations.getDefaultConfigValues(defaultConfigNameSpace, element);
        Annotations.validateDefaultConfigValues(defaultConfigNameSpace, configClass, element, values);
        return values;
    }

    public static List<Map.Entry<String, DefaultConfigProxyValue>> getValidatedDefaultConfigValues(ModuleElement moduleElement) {
        List<Map.Entry<String, DefaultConfigProxyValue>> values = Annotations.getDefaultConfigValues("", moduleElement);
        Annotations.validateDefaultConfigValues(moduleElement, values);
        return values;
    }

    private static void validateDefaultConfigValues(String defaultConfigNameSpace, TypeElement configClass, Element element, List<Map.Entry<String, DefaultConfigProxyValue>> values) {
        Set<String> declaredProperties = Elements.allDeclaredProperties(configClass);
        for (Map.Entry<String, DefaultConfigProxyValue> value : values) {
            String[] namePair = value.getKey().split("\\.");
            String nameSpace = namePair[0];
            if (!defaultConfigNameSpace.equals(nameSpace)) {
                throw new InterruptProcessingException(element, "Invalid namespace for property: '?'. Expected '?', but actual is '?'!", value.getKey(), defaultConfigNameSpace, nameSpace);
            }
            String propertyName = namePair[1];
            if (declaredProperties.contains(propertyName)) continue;
            throw new InterruptProcessingException(element, "Config class '?' does not contain '?' property. Supported properties are : '?'. Fix the name for default config value!", configClass.asType().toString(), propertyName, declaredProperties);
        }
    }

    private static void validateDefaultConfigValues(ModuleElement moduleElement, List<Map.Entry<String, DefaultConfigProxyValue>> values) {
        for (Map.Entry<String, DefaultConfigProxyValue> defaultConfigValue : values) {
            if (!Strings.startsWith((String)defaultConfigValue.getKey(), (char)'.')) continue;
            throw new InterruptProcessingException(moduleElement, "Missing name space for default config name: ?", defaultConfigValue.getKey().substring(1));
        }
    }

    private static List<Map.Entry<String, DefaultConfigProxyValue>> getDefaultConfigValues(String defaultConfigNameSpace, Element element) {
        return Stream.concat(Arrays.stream((DefaultConfigValue[])element.getAnnotationsByType(DefaultConfigValue.class)).map(defaultConfigValue -> Map.entry(Annotations.getDefaultConfigValueName(element, DefaultConfigValue.class, defaultConfigValue.name(), () -> ((DefaultConfigValue)defaultConfigValue).configClass(), defaultConfigNameSpace), new DefaultConfigProxyValue(defaultConfigValue.value()))), Arrays.stream((DefaultConfigValueSupplier[])element.getAnnotationsByType(DefaultConfigValueSupplier.class)).map(defaultConfigValue -> Map.entry(Annotations.getDefaultConfigValueName(element, DefaultConfigValueSupplier.class, defaultConfigValue.name(), () -> ((DefaultConfigValueSupplier)defaultConfigValue).configClass(), defaultConfigNameSpace), new DefaultConfigProxyValue(Annotations.getRequiredAnnotationClassParameter(() -> ((DefaultConfigValueSupplier)defaultConfigValue).supplier()))))).collect(Collectors.toList());
    }

    private static String getDefaultConfigValueName(Element element, Class<? extends Annotation> annotationClass, String name, Supplier<Class<?>> classSupplier, String defaultConfigNameSpace) {
        Optional<TypeElement> annotationClassParameter = Annotations.getAnnotationClassParameter(classSupplier, Config.class);
        if (name.indexOf(46) != -1) {
            if (annotationClassParameter.isPresent()) {
                throw new InterruptProcessingException(element, "Redundant config class! Remove it!", new Object[0]);
            }
            return name;
        }
        annotationClassParameter.ifPresent(typeElement -> Annotations.validateThatConfigClassContainsProperty(element, annotationClass, typeElement, name));
        return annotationClassParameter.map(te -> Config.getDefaultNameSpace((String)Names.getSimpleName(te))).orElse(defaultConfigNameSpace) + "." + name;
    }

    private static void validateThatConfigClassContainsProperty(Element element, Class<? extends Annotation> annotationClass, TypeElement typeElement, String property) {
        if (Elements.findSetter(typeElement, property).isEmpty()) {
            throw new InterruptProcessingException(element, "Invalid 'configClass' or 'name' parameter for @? annotation: '?' class does not contain setter for the '?' property! Change invalid parameter(s)!", annotationClass.getName(), typeElement.getQualifiedName().toString(), property);
        }
    }

    private Annotations() {
    }
}

