/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.virtual;

import io.rxmicro.annotation.processor.common.model.virtual.VirtualElement;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualFieldElement;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualNames;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualTypeMirror;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.util.Requires;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public final class VirtualTypeElement
implements TypeElement,
VirtualElement {
    final String packageName;
    final String className;
    final ExecutableElement method;
    private final TypeElement ownerClass;

    public VirtualTypeElement(String classNameTemplate, ExecutableElement method) {
        this.method = (ExecutableElement)Requires.require((Object)method);
        this.packageName = ((PackageElement)method.getEnclosingElement().getEnclosingElement()).getQualifiedName().toString();
        this.className = VirtualNames.buildVirtualClassName(classNameTemplate, method);
        this.ownerClass = (TypeElement)method.getEnclosingElement();
    }

    @Override
    public ExecutableElement getRealElement() {
        return this.method;
    }

    public List<TypeMirror> getFieldTypes() {
        return this.getEnclosedElements().stream().map(Element::asType).collect(Collectors.toList());
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        return this.getVirtualFieldElements();
    }

    @Override
    public NestingKind getNestingKind() {
        return NestingKind.TOP_LEVEL;
    }

    @Override
    public Name getQualifiedName() {
        return ProcessingEnvironmentHelper.getElements().getName(this.packageName + "." + this.className);
    }

    @Override
    public Name getSimpleName() {
        return ProcessingEnvironmentHelper.getElements().getName(this.className);
    }

    @Override
    public TypeMirror getSuperclass() {
        return ProcessingEnvironmentHelper.getElements().getTypeElement(Object.class.getName()).asType();
    }

    @Override
    public List<? extends TypeMirror> getInterfaces() {
        return List.of();
    }

    @Override
    public List<? extends TypeParameterElement> getTypeParameters() {
        return List.of();
    }

    @Override
    public Element getEnclosingElement() {
        return this.method.getEnclosingElement().getEnclosingElement();
    }

    public List<VirtualFieldElement> getVirtualFieldElements() {
        return this.method.getParameters().stream().map(v -> new VirtualFieldElement(this, (VariableElement)v)).collect(Collectors.toList());
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        Annotation[] annotations = this.method.getAnnotationsByType(annotationType);
        return annotations.length != 0 ? annotations : this.ownerClass.getAnnotationsByType(annotationType);
    }

    @Override
    public TypeMirror asType() {
        return new VirtualTypeMirror(this);
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.CLASS;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Set.of(Modifier.FINAL, Modifier.PUBLIC);
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        List<? extends AnnotationMirror> methodMirrors = this.method.getAnnotationMirrors();
        List<? extends AnnotationMirror> classMirrors = this.ownerClass.getAnnotationMirrors();
        ArrayList<? extends AnnotationMirror> mirrors = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : classMirrors) {
            if (!methodMirrors.stream().noneMatch(m -> m.getAnnotationType().toString().equals(classMirror.getAnnotationType().toString()))) continue;
            mirrors.add(annotationMirror);
        }
        mirrors.addAll(methodMirrors);
        return mirrors;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A annotation = this.method.getAnnotation(annotationType);
        return annotation != null ? annotation : this.ownerClass.getAnnotation(annotationType);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getQualifiedName().toString();
    }
}

