/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.virtual;

import io.rxmicro.common.util.Formats;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

final class VirtualNames {
    public static final String OWNER_SIMPLE_CLASS_NAME = "${owner}";
    public static final String INDEX = "${index}";
    private static final Map<String, AtomicInteger> COUNTER = new HashMap<String, AtomicInteger>();

    static String buildVirtualClassName(String classNameTemplate, ExecutableElement method) {
        Element classElement = method.getEnclosingElement();
        String owner = VirtualNames.getOwner(classElement);
        int index = COUNTER.computeIfAbsent(classElement.asType().toString(), t -> new AtomicInteger(0)).incrementAndGet();
        return Formats.format((String)"???", (Object[])new Object[]{"$$", "Virtual", classNameTemplate.replace(OWNER_SIMPLE_CLASS_NAME, owner).replace(INDEX, index == 1 ? "" : String.valueOf(index))});
    }

    private static String getOwner(Element classElement) {
        String simpleName = classElement.getSimpleName().toString();
        return simpleName.replace("MicroService", "").replace("Microservice", "").replace("Service", "").replace("RestController", "").replace("Controller", "").replace("RestClient", "").replace("Client", "");
    }

    private VirtualNames() {
    }
}

