/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.virtual;

import io.rxmicro.annotation.processor.common.model.virtual.ClassWrapperTypeMirror;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;

public final class ClassWrapperTypeElement
implements TypeElement {
    private final Class<?> typeClass;

    public ClassWrapperTypeElement(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NestingKind getNestingKind() {
        if (this.typeClass.isLocalClass()) {
            return NestingKind.LOCAL;
        }
        if (this.typeClass.isMemberClass()) {
            return NestingKind.MEMBER;
        }
        return NestingKind.TOP_LEVEL;
    }

    @Override
    public Name getQualifiedName() {
        return ProcessingEnvironmentHelper.getElements().getName(this.typeClass.getName());
    }

    @Override
    public Name getSimpleName() {
        return ProcessingEnvironmentHelper.getElements().getName(this.typeClass.getSimpleName());
    }

    @Override
    public TypeMirror getSuperclass() {
        Class<?> superclass = this.typeClass.getSuperclass();
        if (superclass == null) {
            return null;
        }
        return new ClassWrapperTypeMirror(superclass);
    }

    @Override
    public List<? extends TypeMirror> getInterfaces() {
        return Arrays.stream(this.typeClass.getInterfaces()).map(ClassWrapperTypeMirror::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<? extends TypeParameterElement> getTypeParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getEnclosingElement() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return this.typeClass.getAnnotationsByType(annotationType);
    }

    @Override
    public TypeMirror asType() {
        return new ClassWrapperTypeMirror(this.typeClass);
    }

    @Override
    public ElementKind getKind() {
        if (this.typeClass.isEnum()) {
            return ElementKind.ENUM;
        }
        if (this.typeClass.isAnnotation()) {
            return ElementKind.ANNOTATION_TYPE;
        }
        if (this.typeClass.isInterface()) {
            return ElementKind.INTERFACE;
        }
        return ElementKind.CLASS;
    }

    @Override
    public Set<javax.lang.model.element.Modifier> getModifiers() {
        HashSet<javax.lang.model.element.Modifier> result = new HashSet<javax.lang.model.element.Modifier>();
        int modifiers = this.typeClass.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            result.add(javax.lang.model.element.Modifier.ABSTRACT);
        }
        if (Modifier.isFinal(modifiers)) {
            result.add(javax.lang.model.element.Modifier.FINAL);
        }
        if (Modifier.isPublic(modifiers)) {
            result.add(javax.lang.model.element.Modifier.PUBLIC);
        }
        if (Modifier.isProtected(modifiers)) {
            result.add(javax.lang.model.element.Modifier.PROTECTED);
        }
        if (Modifier.isPrivate(modifiers)) {
            result.add(javax.lang.model.element.Modifier.PRIVATE);
        }
        if (Modifier.isStatic(modifiers)) {
            result.add(javax.lang.model.element.Modifier.STATIC);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.typeClass.getAnnotation(annotationType);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.typeClass.getName();
    }
}

