/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.type;

import io.rxmicro.annotation.processor.common.model.ModelAccessorType;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.common.util.Requires;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class ObjectModelClass<T extends ModelField>
extends ModelClass {
    private final TypeMirror modelTypeMirror;
    private final TypeElement modelTypeElement;
    private final Map<T, ModelClass> params;
    private final ObjectModelClass<T> parent;
    private final boolean modelClassReturnedByRestMethod;

    protected ObjectModelClass(TypeMirror modelTypeMirror, TypeElement modelTypeElement, Map<T, ModelClass> params, ObjectModelClass<T> parent, boolean modelClassReturnedByRestMethod) {
        this.modelTypeMirror = (TypeMirror)Requires.require((Object)modelTypeMirror);
        this.modelTypeElement = (TypeElement)Requires.require((Object)modelTypeElement);
        this.params = (Map)Requires.require(params);
        this.parent = parent;
        this.modelClassReturnedByRestMethod = modelClassReturnedByRestMethod;
    }

    public Optional<? extends ObjectModelClass<T>> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public List<ObjectModelClass<T>> getAllParents() {
        if (this.parent == null) {
            return List.of();
        }
        return Stream.concat(Stream.of(this.parent), this.parent.getAllParents().stream()).collect(Collectors.toList());
    }

    @Override
    public String getLoggableFullClassName() {
        if (this.modelClassReturnedByRestMethod) {
            return super.getLoggableFullClassName();
        }
        return "abstract " + super.getLoggableFullClassName();
    }

    public boolean isModelClassReturnedByRestMethod() {
        return this.modelClassReturnedByRestMethod;
    }

    public TypeMirror getModelTypeMirror() {
        return this.modelTypeMirror;
    }

    public TypeElement getModelTypeElement() {
        return this.modelTypeElement;
    }

    @Override
    public String getJavaSimpleClassName() {
        return Names.getSimpleName(this.modelTypeMirror);
    }

    @Override
    public String getJavaFullClassName() {
        return this.modelTypeMirror.toString();
    }

    public boolean isReadReflectionRequired() {
        return this.params.keySet().stream().anyMatch(m -> m.getModelReadAccessorType() == ModelAccessorType.REFLECTION);
    }

    public boolean isWriteReflectionRequired() {
        return this.params.keySet().stream().anyMatch(m -> m.getModelWriteAccessorType() == ModelAccessorType.REFLECTION);
    }

    public Set<Map.Entry<T, ModelClass>> getParamEntries() {
        return this.params.entrySet();
    }

    public boolean isParamEntriesPresent() {
        return !this.params.isEmpty();
    }

    public boolean isParamEntriesPresentAtThisOrAnyParent() {
        return this.isParamEntriesPresent() || this.parent != null && this.parent.isParamEntriesPresentAtThisOrAnyParent();
    }

    public List<TypeMirror> getModelFieldTypes() {
        return this.params.keySet().stream().map(ModelField::getFieldClass).collect(Collectors.toList());
    }

    public Set<ObjectModelClass<T>> getAllChildrenObjectModelClasses() {
        HashSet<ObjectModelClass<T>> result = new HashSet<ObjectModelClass<T>>();
        for (ModelClass modelClass : this.params.values()) {
            Object objectModelClass;
            if (modelClass.isObject()) {
                objectModelClass = modelClass.asObject();
                result.add((ObjectModelClass<T>)objectModelClass);
                result.addAll(((ObjectModelClass)objectModelClass).getAllChildrenObjectModelClasses());
                continue;
            }
            if (!modelClass.isIterable() || !modelClass.asIterable().isObjectIterable()) continue;
            objectModelClass = modelClass.asIterable().getElementModelClass().asObject();
            result.add((ObjectModelClass<T>)objectModelClass);
            result.addAll(((ObjectModelClass)objectModelClass).getAllChildrenObjectModelClasses());
        }
        return result;
    }

    public Collection<Map.Entry<T, ModelClass>> getAllOrderedDeclaredFields() {
        return this.params.entrySet();
    }

    public final Stream<Map.Entry<T, ModelClass>> getAllDeclaredParametersStream() {
        return Stream.concat(this.getAllParents().stream().flatMap(p -> p.getParamEntries().stream()), this.getParamEntries().stream());
    }
}

